package com.yizhi.system.application.controller.manage;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.feign.InternationalClient;
import com.yizhi.site.application.vo.site.SiteLanguageVO;
import com.yizhi.system.application.domain.Internationalization;
import com.yizhi.system.application.enums.InternationalType;
import com.yizhi.system.application.enums.LanguageType;
import com.yizhi.system.application.service.IInternationalizationService;
import com.yizhi.system.application.service.IInternationalizationWordService;
import com.yizhi.util.application.domain.Response;
import com.yizhi.system.application.vo.InternationalizationWordVo;
import com.yizhi.system.application.vo.LanguageTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author taoge123
 * @since 2020-03-17
 */
@Api(tags = "国际化接口")
@RestController
@RequestMapping("/manage/internationalizationWord")
public class InternationalizationWordController {

    @Autowired
    private IInternationalizationWordService internationalizationWordService;
    @Autowired
    private IInternationalizationService internationalizationService;

    private static List<LanguageTypeVo> languageTypeVos = null;

    @Autowired
    private InternationalClient internationalClient;

    static {
        languageTypeVos = new ArrayList<>();
        LanguageType[] values = LanguageType.values();
        if (values != null) {
            for (LanguageType a : values) {
                if (!a.getCode().equals(LanguageType.zh_CN.getCode())) {
                    LanguageTypeVo vo = new LanguageTypeVo();
                    vo.setCode(a.getCode());
                    vo.setName(a.getName());
                    languageTypeVos.add(vo);
                }
            }
        }
    }


    @ApiOperation(value = "管理端获取语种列表", notes = "管理端获取语种列表")
    @GetMapping(value = "/languageType/getList")
    public Response<String> getList() {
        Page<SiteLanguageVO> list = internationalClient.getList(1, 200, 1);
//        return Response.ok(languageTypeVos);
        return Response.ok(list);
    }


    @ApiOperation(value = "新增翻译字段", notes = "前端调用")
    @PostMapping(value = "/add")
    public Response<String> add(@ApiParam("vo") @RequestBody InternationalizationWordVo vo) {
        String type = vo.getType();
//        String value = vo.getValue();
        String languageType = vo.getLanguageType();
        Long internationalizationId = vo.getInternationalizationId();
        //|| value == null || value.trim().equals("")
        if (type == null || languageType == null
                || internationalizationId == null) {
            return Response.fail("必传参数不能为空！");
        }
        //名字自行去siteku的site_dic parentId=82 查看名称
//        try {
//            LanguageType.valueOf(languageType);
//            vo.setLanguageName(LanguageType.valueOf(languageType).getName());
//        } catch (IllegalArgumentException e) {
//            return Response.fail("languageType值不存在或者不符合标准！");
//        }
        try {
            InternationalType.valueOf(type);
        } catch (IllegalArgumentException e) {
            return Response.fail("type值不存在或者不符合标准！");
        }

        Internationalization internationalization = internationalizationService.selectById(internationalizationId);
        if (internationalization == null) {
            return Response.fail("无效的internationalizationId！");
        }
        vo.setName(internationalization.getName());
        vo.setTaskId(internationalization.getTaskId());
        if (internationalizationWordService.add(vo) == 1) {
            return Response.ok("操作成功！");
        }
        return Response.fail("操作失败！");
    }

    @ApiOperation(value = "获取国际化翻译map", notes = "获取国际化翻译map")
    @GetMapping(value = "/remote/getMap")
    public Map<Long, String> getMap(@RequestParam("tableType") String tableType,
                                    @RequestParam("taskIds") List<Long> taskIds,
                                    @RequestParam("languageType") String languageType) {
       return internationalizationWordService.getMapByTaskIds(tableType,taskIds,languageType);
    }
}

