package com.yizhi.system.application.controller.manage;


import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.service.IAuthzMenuService;
import com.yizhi.system.application.vo.ModuleVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.tree.CommonTree;
import com.yizhi.util.application.tree.TreeUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;


/**
 * <p>
 * 模块 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-05-15
 */
@Api(tags = "模块管理")
@RestController
@RequestMapping("/manage/module")
public class ModuleController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleController.class);

    @Autowired
    private IAuthzMenuService moduleService;

    @ApiOperation(value = "模块列表", response = ModuleVo.class)
    @GetMapping("/list")
    public Response<List<CommonTree>> list() {
        try {
            com.yizhi.system.application.domain.Site site = new com.yizhi.system.application.domain.Site();
            site.setId(ContextHolder.get().getSiteId());
            site = site.selectById();

            if (null != site) {
                // 判断是否是运营站点
                Boolean isOperation = site.getOperationSite() == true ? null : false;

                // 先查出通用的
                com.yizhi.system.application.domain.AuthzMenu module = new com.yizhi.system.application.domain.AuthzMenu();
                module.setEnabled(1);
                module.setDeleted(0);
                module.setType(AuthzConstant.MODULE_TYPE_DEFAULT);
                module.setOperationMenu(isOperation);
                List<com.yizhi.system.application.domain.AuthzMenu> modules = module.selectList(new EntityWrapper(module));

                // 查出企业的
                module.setType(AuthzConstant.MODULE_TYPE_COMPANY);
                module.setCompanyId(ContextHolder.get().getCompanyId());
                module.setOperationMenu(isOperation);
                List<com.yizhi.system.application.domain.AuthzMenu> companyModules = module.selectList(new EntityWrapper(module));
                if (!CollectionUtils.isEmpty(companyModules)) {
                    modules.addAll(companyModules);
                }

                // 查出站点的
                module.setType(AuthzConstant.MODULE_TYPE_SITE);
                module.setSiteId(ContextHolder.get().getSiteId());
                module.setCompanyId(null);
                module.setOperationMenu(isOperation);
                List<com.yizhi.system.application.domain.AuthzMenu> siteModules = module.selectList(new EntityWrapper(module));
                if (!CollectionUtils.isEmpty(siteModules)) {
                    modules.addAll(siteModules);
                }

                List<CommonTree> trees = new ArrayList<>();
                for (com.yizhi.system.application.domain.AuthzMenu m : modules) {
                    CommonTree<Long, com.yizhi.system.application.domain.AuthzMenu> tree = new CommonTree<>();
                    tree.setId(m.getId());
                    tree.setName(m.getName());
                    tree.setNode(m);
                    tree.setPId(m.getParentId());
                    trees.add(tree);
                }

                trees = TreeUtil.buildTree(trees, 0L);
                return Response.ok(trees);
            }
            return Response.fail(InternationalEnums.MODULECONTROLLER.getCode());
        } catch (Exception e) {
            LOGGER.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }
}


