package com.yizhi.system.application.controller.manage;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.task.OrgExportAsy;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Api(tags = "组织架构导出")
@RestController
@RequestMapping(value = "/manage/org/export")
public class OrgExportController {
	
    @Autowired
    private IOrganizationService organizationService;
    
    @Autowired
    private OrgExportAsy orgExportAsy;
    
    @ApiOperation(value = "组织架构导出")
    @GetMapping("/excel")
    public Response<String> orgExport(
            @ApiParam("部门id，精确匹配") @RequestParam(name = "orgId", required = false) Long orgId
    ) {
        try {
            // 参数检查
            if (null == orgId) {
                return Response.fail("4001", InternationalEnums.ORGEXPORTCONTROLLER1.getCode());
            }
            Organization org = organizationService.selectById(Long.valueOf(String.valueOf(orgId)));
            if (org == null) {
                return Response.fail("4001", InternationalEnums.ORGEXPORTCONTROLLER2.getName() + orgId);
            }
            // 开始处理
            RequestContext requestContext = ContextHolder.get();
            Date now = new Date();
    		Long taskId = now.getTime();
    		String serialNo = "USER-EXPORT-" + taskId;
    		String taskName = "导出组织架构信息-" + taskId;
    		String result = "任务编号：" + serialNo + "。任务名称：" + taskName;
    		Map<String, Object> map = new HashMap<String, Object>();
    		map.put("accountId", requestContext.getAccountId());
    		map.put("siteId", requestContext.getSiteId());
    		map.put("companyId", requestContext.getCompanyId());
    		map.put("serialNo", serialNo);
    		map.put("taskId", taskId);
    		map.put("taskName", taskName);
    		map.put("submitTime", now);
    		map.put("orgId", orgId);
    		map.put("orgName", org.getName());
    		orgExportAsy.execute(map, true);
            return Response.ok(result);
        } catch (Exception e) {
            return Response.fail();
        }
    }
}
