package com.yizhi.system.application.controller.remote;

import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.resource.ScannerResource;
import com.yizhi.system.application.service.IAuthzResourceService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

@RestController
@RequestMapping("/authz/resource")
public class RemoteAuthzResourceController {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAuthzResourceController.class);

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private IAuthzResourceService authzResourceService;

    @PostMapping("/deal")
    public void deal(@RequestBody List<ScannerResource> scannerResources) {
        Date date = new Date();
        if (CollectionUtils.isNotEmpty(scannerResources)) {
            // 查出库中已经有的
            com.yizhi.system.application.domain.AuthzResource authzResource = new com.yizhi.system.application.domain.AuthzResource();
            List<com.yizhi.system.application.domain.AuthzResource> existed = authzResource.selectAll();
            Set<String> existedUrl = CollectionUtils.isEmpty(existed) ? new HashSet<>() : new HashSet<>(existed.size());
            if (CollectionUtils.isNotEmpty(existed)) {
                for (com.yizhi.system.application.domain.AuthzResource r : existed) {
                    existedUrl.add(r.getUrl());
                }
            }

            List<com.yizhi.system.application.domain.AuthzResource> authzResources = new ArrayList<>();
            String[] mappings = null;
            for (ScannerResource r : scannerResources) {
                mappings = r.getRequestMappings();
                if (mappings == null) {
                    continue;
                }

                for (String s : mappings) {
                    if (existedUrl.contains(s)) {
                        continue;
                    }
                    com.yizhi.system.application.domain.AuthzResource resource = new com.yizhi.system.application.domain.AuthzResource();
                    resource.setCreateById(0L);
                    resource.setCreateByName("0");
                    resource.setCreateTime(date);
                    resource.setId(idGenerator.generate());
//                    resource.setModuleCode(s.get);
                    resource.setName(r.getMethodFunction());
                    resource.setStatus(1);
                    resource.setType("B");
                    resource.setUrl(s);
                    authzResources.add(resource);
                }
            }

            if (CollectionUtils.isNotEmpty(authzResources)) {
                authzResourceService.insertBatch(authzResources);
                LOGGER.info("本次新入库资源：{} 条", authzResources.size());
            }
        }
    }

}
