package com.yizhi.system.application.controller.remote;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import com.yizhi.system.application.mapper.DaIndicatorLoginDayMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.system.application.service.DaIndicatorService;
import com.yizhi.system.application.service.ILoginLogService;
import com.yizhi.util.application.num.NumUtil;
import com.yizhi.system.application.vo.RemoteDaIndicatorVo;
import com.yizhi.system.application.vo.ReportRangeAccountReqVO;
import com.yizhi.system.application.vo.domain.*;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * @ClassName DaIndicatorAccountController
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2019-10-09 16:52
 * @Version 1.0
 */
@RestController
@RequestMapping("/remote/da/system/")
public class RemoteDaIndicatorController {

    @Autowired
    private ReportAccountController reportAccountController;
    @Autowired
    private ILoginLogService loginLogService;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private DaIndicatorService daIndicatorService;
    @Autowired
    private DaIndicatorLoginDayMapper daIndicatorLoginDayMapper;

    /**
     * dashboard - 活跃用户比例
     *
     * @return
     */
    @PostMapping("account")
    public boolean account(@RequestBody RemoteDaIndicatorVo vvo) {
        Long siteId = vvo.getSiteId();
        Date startDate = vvo.getStartDate();
        Date endDate = vvo.getEndDate();
        Date processTime = vvo.getProcessTime();

        // 查询站点下总人数
        ReportRangeAccountReqVO vo = new ReportRangeAccountReqVO();
        vo.setSiteId(siteId);
        Long preAccountNumInSite = reportAccountController.getRangeAccountCountNum(vo);

        String weekChain = "-";
        String accountActivePercentage = "-";
        Integer preAccountActiveNum;

        if (preAccountNumInSite != null && preAccountNumInSite > 0) {
            preAccountActiveNum = loginLogService.countActiveAccount(siteId, startDate, endDate);

            if (preAccountActiveNum != null && preAccountActiveNum > 0) {
                // 整数，四舍五入
                accountActivePercentage = NumUtil.getPercentage(preAccountActiveNum, preAccountNumInSite, 2);

                Date dateOfPreWeek = DateUtil.offset(startDate, DateField.DAY_OF_YEAR, -7);
                Date preStartDate = DateUtil.beginOfWeek(dateOfPreWeek);
                Date preEndDate = DateUtil.endOfWeek(dateOfPreWeek);

                Integer preWeekAccountActiveNum = loginLogService.countActiveAccount(siteId, preStartDate, preEndDate);

                Date dateOfPrePreWeek = DateUtil.offset(preStartDate, DateField.DAY_OF_YEAR, -7);
                Date prePreStartDate = DateUtil.beginOfWeek(dateOfPrePreWeek);
                Date prePreEndDate = DateUtil.endOfWeek(dateOfPrePreWeek);

                Integer prePreWeekAccountActiveNum = loginLogService.countActiveAccount(siteId, prePreStartDate, prePreEndDate);

                if (prePreWeekAccountActiveNum != null && prePreWeekAccountActiveNum > 0) {
                    weekChain = NumUtil.getChainPercentage(preWeekAccountActiveNum, prePreWeekAccountActiveNum, 0);
                }
            }

            com.yizhi.system.application.domain.DaIndicatorAccount daIndicatorAccount = new com.yizhi.system.application.domain.DaIndicatorAccount();
            daIndicatorAccount.setId(idGenerator.generate());
            daIndicatorAccount.setAccountActive(preAccountActiveNum);
            daIndicatorAccount.setAccountTotal(new Integer(preAccountNumInSite + ""));
            daIndicatorAccount.setEndDay(endDate);
            daIndicatorAccount.setStartDay(startDate);
            daIndicatorAccount.setProcessTime(processTime);
            daIndicatorAccount.setSiteId(siteId);
            daIndicatorAccount.setWeekChain(weekChain);
            daIndicatorAccount.setAccountActivePercentage(accountActivePercentage);
            return daIndicatorAccount.insert();
        }
        return false;
    }

    @PostMapping("insertCourseFinish")
    public boolean insertCourseFinish(@RequestBody DaIndicatorCourseFinish record) {
        com.yizhi.system.application.domain.DaIndicatorLoginDay daIndicatorLoginDay = new com.yizhi.system.application.domain.DaIndicatorLoginDay();
        BeanUtils.copyProperties(record,daIndicatorLoginDay);
        return daIndicatorLoginDay.insert();
    }

    @PostMapping("insertCourseTime")
    public boolean insertCourseTime(@RequestBody DaIndicatorCourseTime record) {
        com.yizhi.system.application.domain.DaIndicatorCourseTime daIndicatorLoginDay = new com.yizhi.system.application.domain.DaIndicatorCourseTime();
        BeanUtils.copyProperties(record,daIndicatorLoginDay);
        return daIndicatorLoginDay.insert();
    }

    @PostMapping("insertTpFinish")
    public boolean insertTpFinish(@RequestBody DaIndicatorTpFinish record) {
        com.yizhi.system.application.domain.DaIndicatorTpFinish daIndicatorLoginDay = new com.yizhi.system.application.domain.DaIndicatorTpFinish();
        BeanUtils.copyProperties(record,daIndicatorLoginDay);
        return daIndicatorLoginDay.insert();
    }

    @PostMapping("accountDay")
    public boolean accountDay(@RequestBody RemoteDaIndicatorVo vo) {
        com.yizhi.system.application.domain.DaIndicatorLoginDay record = new com.yizhi.system.application.domain.DaIndicatorLoginDay();
        record = daIndicatorLoginDayMapper.selectOneDay(vo.getSiteId(), vo.getDay());
        if (record != null) {
            record.setPcPersonNum(record.getPcPersonNum() - record.getMixPersonNum());
            record.setMobilePersonNum(record.getMobilePersonNum() - record.getMixPersonNum());

            record.setMixPersonTime(record.getPersonTime() - record.getMobilePersonTime() - record.getPcPersonTime());
            record.setProcessTime(vo.getProcessTime());
            record.setDay(vo.getDay());
            record.setId(idGenerator.generate());
            record.setSiteId(vo.getSiteId());
        }

        return record.insert();
    }
}
