package com.yizhi.system.application.controller.remote;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.system.application.domain.AuthzUserGroup;
import com.yizhi.system.application.domain.Company;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.system.application.service.IAuthzUserGroupService;
import com.yizhi.system.application.vo.UserGroupVO;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;

/**
 * 用户组远程调用接口
 * @author yinyuyan
 *
 */
@RestController
@RequestMapping(value="/remote/group")
@Slf4j
public class RemoteGroupController {

	private static final Logger LOG = LoggerFactory.getLogger(RemoteGroupController.class);

	@Autowired
	IAuthzUserGroupService groupService;
	@Autowired
	private DomainConverter converter;
	/**
	 * 根据用户组id获取详情
	 * @param groupId
	 * @return
	 */
	@GetMapping(value="/get")
	public UserGroupVO findById(@RequestParam Long groupId){
		return (UserGroupVO)converter.toDO(groupService.findById(groupId), UserGroupVO.class);
	}

	/**
	 * 社群group同步
	 * @param date
	 * @return
	 */
	@PostMapping(value="/public/community/syncUserGroup")
	public List<AuthzUserGroup> syncUserGroup(@RequestParam("indexTime") long indexTime){
		log.info("===================社群group同步==========================");
		EntityWrapper<AuthzUserGroup> wrapper = new EntityWrapper<>();
		wrapper.gt("index_time", DateUtil.formatDateTime(new Date(indexTime)));
		List<AuthzUserGroup> userGroups = groupService.selectList(wrapper);
		if (CollectionUtils.isEmpty(userGroups)){
			return null;
		}
		return userGroups;
	}
}
