package com.yizhi.system.application.controller.remote;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.system.application.domain.AuthzGroupMember;
import com.yizhi.system.application.service.IAuthzGroupMemberService;
import com.yizhi.system.application.service.IAuthzUserGroupService;
import com.yizhi.system.application.util.CollectionUtil;
import com.yizhi.system.application.vo.UserGroupVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;

/**
 * 用户组远程调用接口
 * @author yinyuyan
 *
 */
@RestController
@RequestMapping(value="/remote/groupMember")
@Slf4j
public class RemoteGroupMemberController {

	private static final Logger LOG = LoggerFactory.getLogger(RemoteGroupMemberController.class);

	@Autowired
	private IAuthzGroupMemberService groupMemberService;

	/**
	 * 社群管辖区人员同步
	 * @param date
	 * @return
	 */
	@PostMapping(value="/public/community/syncGroupMember")
	public List<AuthzGroupMember> syncGroupMember(@RequestParam("indexTime") long indexTime){
		log.info("===================社群groupMember同步==========================");
		EntityWrapper<AuthzGroupMember> wrapper = new EntityWrapper<>();
		wrapper.gt("index_time", DateUtil.formatDateTime(new Date(indexTime)));
		List<AuthzGroupMember> authzGroupMembers = groupMemberService.selectList(wrapper);
		if (CollectionUtils.isEmpty(authzGroupMembers)){
			return null;
		}
		return authzGroupMembers;
	}
}
