package com.yizhi.system.application.controller.remote;

import com.alibaba.fastjson.JSON;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.system.application.vo.ReportOrgReqVO;
import com.yizhi.system.application.vo.ReportOrgRespVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 16:31 2018/7/16
 * @Modified By
 */
@RestController
@RequestMapping(value="/remote/report/org")
public class ReportOrgController {

    private static final Logger logger = LoggerFactory.getLogger(ReportOrgController.class);


    @Autowired
    private IOrganizationService organizationService;

    /**
     * 报表获取用户信息列表
     * @param reportOrgReqVO
     * @return
     */
    @PostMapping(value = "/list")
    public PageInfo<ReportOrgRespVO> getOrgs(@RequestBody ReportOrgReqVO reportOrgReqVO){
        PageInfo<ReportOrgRespVO> ret = new PageInfo<>();
        logger.info("获取部门信息请求的参数：{}" + JSON.toJSONString(reportOrgReqVO));

        // 上下文信息
        RequestContext requestContext = reportOrgReqVO.getRequestContext();
        // 获取管理的用户组织信息
        List<Long> orgs = organizationService.getMgrOrgs(requestContext);

        // 查询站点信息
        if(CollectionUtils.isEmpty(orgs)){
            return ret;
        }
        ret = organizationService.getOrgsCountUser(orgs,reportOrgReqVO.getPageNo(),
                reportOrgReqVO.getPageSize(),reportOrgReqVO.getOrgCodeOrOrgName());

        // 获取每个组织的的父组织
        Long companyId = requestContext.getCompanyId();
        List<ReportOrgRespVO> respVOS = ret.getRecords();
        if(!CollectionUtils.isEmpty(respVOS)){
            respVOS.forEach(item -> { item.setParentOrgNames(
                    organizationService.listParentNameIds(item.getOrgId())); });
        }
        return ret;
    }

    @GetMapping(value = "/account/list")
    public List<Long> getAccountsByOrgId(@RequestParam Long orgId){
        List<Long> ret = new ArrayList<>();
        ret = organizationService.getAccountsByOrgId(orgId);
        return ret;
    }
}
