package com.yizhi.system.application.controller.scanner;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.poi.hssf.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @Author: shengchenglong
 * @Date: 2018/5/9 09:41
 */
@Api(tags = "账号Api接口")
@RestController
@RequestMapping(value = "/export")
public class ScannerTest {

    @Autowired
    private ApplicationContext context;

    @ApiOperation(value = "导出Controller关联的url", notes = "导出Controller关联的url")
    @GetMapping(value = "/mappingUrl")
    public String requestMappings() {
        List<ScannerOperation> list = new ArrayList<>();
        Map<String, Object> map = context.getBeansWithAnnotation(Controller.class);

        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object controller = entry.getValue();

            String controllerMapping = "";
            controllerMapping = controller.getClass().getAnnotation(RequestMapping.class) == null ? "/" : controller.getClass().getAnnotation(RequestMapping.class).value()[0];
            if (!controllerMapping.startsWith("/")) {
                controllerMapping = "/" + controllerMapping;
            }
            if (controllerMapping.endsWith("/")) {
                controllerMapping = controllerMapping.substring(0, controllerMapping.length() - 1);
            }

            Method[] methods = controller.getClass().getMethods();
            for (Method method : methods) {
                ScannerOperation operation = new ScannerOperation();
                operation.setControllerName(controller.getClass().getName());
                operation.setControllerFunction(controller.getClass().getAnnotation(Api.class) == null ? "" : controller.getClass().getAnnotation(Api.class).tags()[0]);

                String[] requestMappings = null;
                if (null != method.getAnnotation(RequestMapping.class)) {
                    requestMappings = method.getAnnotation(RequestMapping.class).value();
                } else if (null != method.getAnnotation(GetMapping.class)) {
                    requestMappings = method.getAnnotation(GetMapping.class).value();
                } else if (null != method.getAnnotation(PostMapping.class)) {
                    requestMappings = method.getAnnotation(PostMapping.class).value();
                } else {
                    continue;
                }

                for (int i = 0; i < requestMappings.length; i++) {
                    if (!requestMappings[i].startsWith("/")) {
                        requestMappings[i] = "/" + requestMappings[i];
                    }
                    requestMappings[i] = controllerMapping + requestMappings[i];
                }
                operation.setRequestMappings(requestMappings);
                operation.setMethodName(method.getName());
                operation.setMethodFunction(method.getAnnotation(ApiOperation.class) == null ? "" : method.getAnnotation(ApiOperation.class).value());
                list.add(operation);
            }
        }

        //第一步创建workbook
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle style = wb.createCellStyle();

        //第二步创建sheet
        HSSFSheet sheet = wb.createSheet("sheet1");

        //第三步创建行row
        HSSFRow row = null;
        //第四步创建单元格
        HSSFCell cell = null;

        row = sheet.createRow(0);
        cell = row.createCell(0);
        cell.setCellValue("模块名称");

        cell = row.createCell(1);
        cell.setCellValue("controller名称");

        cell = row.createCell(2);
        cell.setCellValue("功能名称");

        cell = row.createCell(3);
        cell.setCellValue("方法名称");

        cell = row.createCell(4);
        cell.setCellValue("路径映射（多个由英文逗号分隔）");


        for (int i = 1; i <= list.size(); i++) {
            ScannerOperation operation = list.get(i - 1);

            row = sheet.createRow(i);

            cell = row.createCell(0);
            cell.setCellValue(operation.getControllerFunction());

            cell = row.createCell(1);
            cell.setCellValue(operation.getControllerName());

            cell = row.createCell(2);
            cell.setCellValue(operation.getMethodFunction());

            cell = row.createCell(3);
            cell.setCellValue(operation.getMethodName());

            cell = row.createCell(4);
            String val = Arrays.toString(operation.getRequestMappings());
            cell.setCellValue(val.substring(1).substring(0, val.length() - 2));
        }


        //第六步将生成excel文件保存到指定路径下
        try {
            FileOutputStream fout = new FileOutputStream("d:/mapingUrl.xls");
            wb.write(fout);
            fout.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return "Excel文件生成成功...";

//        ExcelWriter ew = new ExcelWriter("classpath://");
//        ew.write(list);
    }

}
