package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 角色表
 * </p>
 *
 * @author 谢海军123
 * @since 2018-03-12
 */
@Data
@Api(tags = "Role", description = "角色表")
@TableName("authz_role")
public class AuthzRole extends Model<AuthzRole> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "角色id")
    private Long id;

    @ApiModelProperty(value = "编码")
    private String code;

    @ApiModelProperty(value = "角色名称")
    private String name;

    @ApiModelProperty(value = "是否启用：0否，1是；默认1")
    private Integer enabled;

    @ApiModelProperty(value = "角色描述")
    private String description;

    @ApiModelProperty(value = "站点id")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "公司id(内置角色，值为0)")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "创建者id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    @TableField(value = "update_by_id", fill = FieldFill.UPDATE)
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    @TableField(value = "update_by_name", fill = FieldFill.UPDATE)
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    @ApiModelProperty(value = "关联用户数，不持久化")
    @TableField(exist = false)
    private Integer relevanceNum;
    
    @ApiModelProperty(value = "模块id列表")
    @TableField(exist = false)
    private List<Long> menuIds;
    
    @ApiModelProperty(value = "管辖区id列表")
    @TableField(exist = false)
    private List<Long> groupIds;

    @ApiModelProperty(value = "被管理的管理员的用户 id集合")
    @TableField(exist = false)
    private List<Long> managerAccountIds;

    @ApiModelProperty(value = "被管理的管理员的用户名")
    @TableField(exist = false)
    private String managerAccountNames = "";

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
