package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author: shengchenglong
 * @Date: 2019/2/25 10:11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Api(tags = "AuthzRoleManager", description = "分级授权关联表，该角色可管理以下管理员的业务数据")
@TableName("authz_role_manager")
public class AuthzRoleManager extends Model<AuthzRoleManager> {

    @ApiModelProperty(value = "主键 id")
    private Long id;

    @ApiModelProperty(value = "角色 id")
    @TableField("role_id")
    private Long roleId;

    @ApiModelProperty(value = "被管理的管理员的用户 id")
    @TableField("manager_account_id")
    private Long managerAccountId;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
