package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 学习组
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-04-16
 */
@Data
@Api(tags = "UserGroup", description = "后台管辖区")
@TableName("authz_user_group")
public class AuthzUserGroup extends Model<AuthzUserGroup> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "管辖区名称")
    private String name;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "所属站点id")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "所属企业id")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "是否删除(0:否,1:是)")
    private Boolean deleted;

    @ApiModelProperty(value = "创建者id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "索引时间")
    @TableField(value = "index_time")
    private Date indexTime;

    @ApiModelProperty(value = "关联账号数")
    @TableField(exist = false)
	private Integer accountCount;

    @ApiModelProperty(value = "账号id列表")
    @TableField(exist = false)
	private List<Long> accountIds;

    @ApiModelProperty(value = "部门id列表")
    @TableField(exist = false)
	private List<Long> orgIds;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
