package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 企业管理
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
@Data
@Api(tags = "Company", description = "企业管理")
@TableName("company")
public class Company extends Model<Company> implements Serializable{

    private static final long serialVersionUID = 1L;

    /**
     * 授权码,企业直接访问api接口（定制访问）
     */
    @ApiModelProperty(value = "授权码")
    @TableField(value = "auth_code")
    private String authCode;

    @ApiModelProperty(value = "公司id")
	private Long id;

    @ApiModelProperty(value = "企业编码")
	private String code;

    @ApiModelProperty(value = "中文名字")
	private String name;

    @ApiModelProperty(value = "英文名字")
	@TableField("en_name")
	private String enName;

    @ApiModelProperty(value = "企业logo图标")
	private String logo;

    @ApiModelProperty(value = "企业简介")
	private String context;

    @ApiModelProperty(value = "行业类型1保险2金融3证券4其它")
	@TableField("category_id")
	private Integer categoryId;

    @ApiModelProperty(value = "企业地址")
    @TableField("address")
	private String address;

    @ApiModelProperty(value = "状态(1:初始化，2：启用，3：停用)")
	private Integer status;

    @ApiModelProperty(value = "到期时间")
	@TableField("expired_time")
	private Date expiredTime;
    
    @ApiModelProperty(value = "企业域名")
    @TableField("domain")
	private String domain;

    @ApiModelProperty(value = "创建人id")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

    @ApiModelProperty(value = "创建人姓名")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

    @ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

    @ApiModelProperty(value = "更新人id")
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

    @ApiModelProperty(value = "更新人姓名")
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

    @ApiModelProperty(value = "更新时间")
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

    @ApiModelProperty(value = "索引时间")
    @TableField(value = "index_time")
    private Date indexTime;
    
    @ApiModelProperty(value = "超级管理员账号")
    @TableField(exist=false)
    private Account superAdmin;
    
    @ApiModelProperty(value = "联系人列表")
    @TableField(exist=false)
    private List<CompanyContactor> contactors;
    
    @ApiModelProperty(value = "关闭账号的人数")
    @TableField(exist=false)
    private Integer memberCloseCount;
    
    @ApiModelProperty(value = "总账号人数")
    @TableField(exist=false)
    private Integer memberCount;
    
    @ApiModelProperty(value = "总部门数")
    @TableField(exist=false)
    private Integer orgCount;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
