package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 公司联系人
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
@Data
@Api(tags = "CompanyContactor", description = "公司联系人")
@TableName("company_contactor")
public class CompanyContactor extends Model<CompanyContactor> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
	private Long id;

    @ApiModelProperty(value = "姓名")
	private String name;

    @ApiModelProperty(value = "性别('M':男,'F':女)")
	private String sex;

    @ApiModelProperty(value = "职务")
	private String position;

    @ApiModelProperty(value = "电话")
	private String telephone;

@ApiModelProperty(value = "邮箱")
	private String email;

@ApiModelProperty(value = "公司id")
	@TableField("company_id")
	private Long companyId;

@ApiModelProperty(value = "是否删除(0:否,1:是)")
	private Boolean deleted;

@ApiModelProperty(value = "创建者id")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

@ApiModelProperty(value = "创建者名称")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

@ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

@ApiModelProperty(value = "更新者id")
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

@ApiModelProperty(value = "修改者名称")
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

@ApiModelProperty(value = "修改时间")
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	@ApiModelProperty(value = "备注")
	private String remark;




	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
