package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 活跃用户比例
 * </p>
 *
 * @author shengchenglong
 * @since 2019-10-09
 */
@Data
@Api(tags = "DaIndicatorAccount", description = "活跃用户比例")
@TableName("da_indicator_account")
public class DaIndicatorAccount extends Model<DaIndicatorAccount> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "站点id")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "站点总人数")
    @TableField("account_total")
    private Integer accountTotal;

    @ApiModelProperty(value = "活跃人数（登陆一次就算）")
    @TableField("account_active")
    private Integer accountActive;

    @ApiModelProperty(value = "活跃用户比例")
    @TableField("account_active_percentage")
    private String accountActivePercentage;

    @ApiModelProperty(value = "周环比（（上周登录人数-上上周登录人数）/上周登录人数×100%）")
    @TableField("week_chain")
    private String weekChain;

    @ApiModelProperty(value = "统计开始天数（一周）")
    @TableField("start_day")
    private Date startDay;

    @ApiModelProperty(value = "统计结束天数（一周）")
    @TableField("end_day")
    private Date endDay;

    @ApiModelProperty(value = "处理时间")
    @TableField("process_time")
    private Date processTime;

    @ApiModelProperty(value = "模块类型（预留）")
    private Integer module;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
