package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 数据字典实体
 * </p>
 *
 * @author shengchenglong
 * @since 2018-01-04
 */
@Data
@Api(tags = "dictionary", description = "数据字典实体")
@TableName("dictionary")
public class Dictionary extends Model<Dictionary> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
	@ApiModelProperty(notes = "主键id")
	private Long id;
    /**
     * 字典code
     */
	@ApiModelProperty(notes = "字典code")
	private String code;
    /**
     * 中文名称
     */
	@ApiModelProperty(notes = "中文名称")
	@TableField(value = "cn_name")
	private String cnName;
    /**
     * 英文名称
     */
	@ApiModelProperty(notes = "英文名称")
	@TableField(value = "en_name")
	private String enName;
    /**
     * 字典取值
     */
	@ApiModelProperty(notes = "字典取值")
	private String value;
    /**
     * 根id（当前为顶层则为“0”）
     */
	@ApiModelProperty(notes = "根id（当前为顶层则为“0”）")
	@TableField(value = "root_id")
	private Long rootId;
    /**
     * 父字典的id（当前为顶层为“0”）
     */
	@ApiModelProperty(notes = "父字典的id（当前为顶层为“0”）")
	@TableField(value = "parent_id")
	private Long parentId;
    /**
     * 节点层级（当前为顶层则为“0”）
     */
	@ApiModelProperty(notes = "节点层级（当前为顶层则为“0”）")
	private Integer layer;
    /**
     * 同层级排序（从1开始）
     */
	@ApiModelProperty(notes = "同层级排序（从1开始）")
	private Integer sort;
    /**
     * 字典描述
     */
	@ApiModelProperty(notes = "字典描述")
	private String description;
    /**
     * 是否可用：0：不可用，1：可用
     */
	@ApiModelProperty(notes = "是否可用：0：不可用，1：可用")
	private Boolean enabled;
    /**
     * 字典类型：0：系统字典，1：业务选项
     */
	@ApiModelProperty(notes = "字典类型：0：系统字典，1：业务选项")
	@TableField(value = "system_flag")
	private Integer systemFlag;
    /**
     * 创建者id
     */
	@ApiModelProperty(notes = "创建者id")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;
    /**
     * 创建者名称
     */
	@ApiModelProperty(notes = "创建者名称")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;
    /**
     * 创建时间
     */
	@ApiModelProperty(notes = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;
    /**
     * 更新者id
     */
	@ApiModelProperty(notes = "更新者id")
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;
    /**
     * 修改者名称
     */
	@ApiModelProperty(notes = "修改者名称")
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;
    /**
     * 修改时间
     */
	@ApiModelProperty(notes = "修改时间")
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;


	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
