package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author taoge123
 * @since 2020-03-17
 */
@Data
@ApiModel(value = "InternationalizationWord", description = "")
@TableName("internationalization_word")
public class InternationalizationWord {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
	private Long id;

    @ApiModelProperty(value = "国际化目标字段id")
	@TableField("internationalization_id")
	private Long internationalizationId;

	@ApiModelProperty(value = "业务id")
	private Long taskId;

    @ApiModelProperty(value = "国际化类型：system(系统定义)、DIY(自定义)")
	private String type;

    @ApiModelProperty(value = "语种类型：en_US、it_IT")
	@TableField("language_type")
	private String languageType;

    @ApiModelProperty(value = "语种名称")
	@TableField("language_name")
	private String languageName;

    @ApiModelProperty(value = "自定义中文名称")
	private String name;

    @ApiModelProperty(value = "翻译内容")
	@TableField("value")
	private String value;


	@TableField("org_id")
	private Long orgId;

	@TableField("site_id")
	private Long siteId;

	@TableField("company_id")
	private Long companyId;

    @ApiModelProperty(value = "是否删除(0:否,1:是)")
	private Integer deleted;

    @ApiModelProperty(value = "创建者id")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

    @ApiModelProperty(value = "创建者名称")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

    @ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

    @ApiModelProperty(value = "更新者id")
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

    @ApiModelProperty(value = "修改者名称")
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

    @ApiModelProperty(value = "修改时间")
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;



}
