package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 敏感词
 * </p>
 *
 * @author moni.yin123
 * @since 2018-04-08
 */
@Data
@Api(tags = "敏感词", description = "敏感词")
@TableName("sensitive_word")
public class SensitiveWord extends Model<SensitiveWord> {

    private static final long serialVersionUID = 1L;


@ApiModelProperty(value = "序号")
	private Long id;

@ApiModelProperty(value = "名称")
	private String name;

@ApiModelProperty(value = "是否删除(0:否,1:是)")
	private boolean deleted;

@ApiModelProperty(value = "租户(公司)id")
	@TableField("company_id")
	private Long companyId;

@ApiModelProperty(value = "创建人id")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

@ApiModelProperty(value = "创建人名称")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

@ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;


	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
