package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.annotations.TableLogic;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * site_protect
 * @author 
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SiteProtect implements Serializable {

    private Long id;

    /**
     * 维护名称
     */
    private String name;

    /**
     * 删除标识，0未删除 1已删除
     */
    @TableLogic
    private Boolean deleted;

    /**
     * 关站通知标识  0没有 1有
     */
    private Boolean closeFlag;

    /**
     * 站内通知标识  0没有 1有
     */
    private Boolean innerFlag;

    private Long createById;

    private Long updateById;

    private Date createTime;

    private Date updateTime;

    /**
     * 创建人name
     */
    private String createByName;

    private String updateByName;

    private static final long serialVersionUID = 1L;

}