package com.yizhi.system.application.domain;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotations.TableLogic;
import com.yizhi.system.application.enums.SiteNoticeEnum;
import com.yizhi.system.application.enums.SiteProtectEnum;
import lombok.Data;

/**
 * site_protect_notice
 * @author 
 */
@Data
public class SiteProtectNotice implements Serializable {
    private Long id;

    /**
     * site_protect id
     */
    private Long siteProtectId;

    /**
     * 通知类型  INNER站内 CLOSE关站
     */
    private SiteNoticeEnum noticeType;

    /**
     * 通知内容
     */
    private String message;

    private Date createTime;

    private Date updateTime;

    private String createByName;

    private String updateByName;

    private Long updateById;

    private Long createById;

    /**
     * 站点类型， ALL 所有站点， PART 自选站点
     */
    private SiteProtectEnum siteType;

    /**
     * 删除标识 0未删除  1已删除
     */
    @TableLogic(value = "0",delval = "1")
    private Boolean deleted;

    private Date startTime;

    private Date endTime;

    private static final long serialVersionUID = 1L;
}