package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 短信发送记录表
 * </p>
 *
 * @author 谢海军123
 * @since 2018-12-06
 */
@Data
@ApiModel(value = "SmsSendRecord", description = "短信发送记录表")
@TableName("sms_send_record")
public class SmsSendRecord {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "唯一编码")
	private Long id;

    @ApiModelProperty(value = "发送流水号,从调用发送接口返回值中获取")
	@TableField("biz_id")
	private String bizId;

    @ApiModelProperty(value = "手机号码(如果是批量发送，关联手机号批量发送表的id)")
	@TableField("phone_num")
	private Long phoneNum;

    @ApiModelProperty(value = "模板ID")
	@TableField("template_code")
	private String templateCode;

    @ApiModelProperty(value = "模板参数 :格式{\"code\":\"verifyCode\"}")
	@TableField("template_param")
	private String templateParam;

	@ApiModelProperty(value = "发送短信的业务类型：first.login.sms.biz.type 首次登陆短信，forget.pwd.sms.biz.type 忘记密码短信；mobile.login.sms.biz.type 手机号登陆短信;update.mobile.sms.biz.type 修改手机号")
	@TableField("template_type")
	private String templateType;

    @ApiModelProperty(value = "外部流水扩展字段")
	@TableField("out_id")
	private String outId;

    @ApiModelProperty(value = "上行短信扩展码,无特殊需要此字段的用户请忽略此字段")
	@TableField("sms_up_extend_code")
	private String smsUpExtendCode;

    @ApiModelProperty(value = "发送短信的业务类型：first.login.sms.biz.type 首次登陆短信，forget.pwd.sms.biz.type 忘记密码短信；mobile.login.sms.biz.type 手机号登陆短信")
	@TableField("biz_type")
	private String bizType;

    @ApiModelProperty(value = "企业id")
	@TableField("company_id")
	private Long companyId;

    @ApiModelProperty(value = "站点Id")
	@TableField("site_id")
	private Long siteId;

    @ApiModelProperty(value = "业务标识（登陆存用id,考试存考试的id......其他业务类似）")
	@TableField("business_Logo")
	private Long businessLogo;

    @ApiModelProperty(value = "数据创建时间")
	@TableField(value = "create_date", fill = FieldFill.INSERT)
	private Date createDate;

    @ApiModelProperty(value = "短信签名")
	@TableField("sign_name")
	private String signName;

    @ApiModelProperty(value = "数据更新时间")
	@TableField(value = "update_time", fill = FieldFill.UPDATE)
	private Date updateTime;

    @ApiModelProperty(value = "发送类型：simple.send.sms 单次发送；batch.send.sms 批量发送")
	@TableField("send_type")
	private String sendType;

	@ApiModelProperty(value = "扩展字段，一些特殊业务使用")
	@TableField("extend")
    private String extend;



}
