package com.yizhi.system.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author hutao123
 * @since 2019-05-07
 */
@Data
@Api (tags = "SwhyKey", description = "")
@TableName ("swhy_key")
public class SwhyKey extends Model<SwhyKey> {

    private static final long serialVersionUID = 1L;


    @TableId ("id")
    private Integer id;

    @ApiModelProperty (value = "公钥")
    @TableField ("public_key")
    private String publicKey;

    @ApiModelProperty (value = "私钥")
    @TableField ("private_key")
    private String privateKey;

    @ApiModelProperty (value = "uuid 签名 对应返回vo里的signature")
    @TableField ("uuid")
    private String uuid;

    @ApiModelProperty (value = "过期时间")
    @TableField ("expire_time")
    private Date expireTime;

    @ApiModelProperty (value = "租户(公司)id")
    @TableField ("company_id")
    private Long companyId;

    @ApiModelProperty (value = "创建者id")
    @TableField (value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty (value = "创建者名称")
    @TableField (value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty (value = "创建时间")
    @TableField (value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    
    @ApiModelProperty (value = "是否开启用户名明文传参，0=不开启 1=开启") 
    @TableField (value = "rsa_state")
    private Integer rsaState;

    @ApiModelProperty (value = "和接入方约定的密钥（特定场景下使用）")
    @TableField (value = "app_secret")
    private String appSecret;

    @ApiModelProperty (value = "客户提供的验证url（特定场景下使用）")
    @TableField (value = "client_url")
    private String clientUrl;
    
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
