package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.system.application.domain.AuthzUserGroup;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 学习组 Mapper 接口
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-04-16
 */
public interface AuthzUserGroupMapper extends BaseMapper<AuthzUserGroup> {
    /**
     * 查询重name的用户组数量
     *
     * @param id
     * @param companyId
     * @param name
     * @return
     */
    @Select("select count(*)  from authz_user_group where "
            + "id <> #{id} and name = #{name} and company_id= #{companyId} and site_id= #{siteId} and deleted=0")
    int countExistName(@Param(value = "id") Long id, @Param(value = "name") String name,
                       @Param(value = "companyId") Long companyId, @Param(value = "siteId") Long siteId);

    /**
     * 根据角色id来查询管辖区
     *
     * @param roleId
     * @return
     */
    @Select("select tb.`id` from authz_user_group tb " +
            "left join role_user_group rug on rug.roleId = #{roleId}")
    List<Long> selectIdsByRoleId(@Param("roleId") Long roleId);

    /**
     * 根据角色id获取管辖的管辖区
     *
     * @param roleIds
     * @return
     */
    @Select("<script>" +
            "select tb.id " +
            "from authz_user_group tb " +
            "left join authz_role_user_group rug on rug.user_group_id = tb.id " +
            "where rug.role_id in" +
            "<foreach collection='roleIds' open='(' close=')' separator=',' item='roleId' index='index'> " +
            "#{roleId,jdbcType=BIGINT} " +
            "</foreach>" +
            "</script>")
    Set<Long> getByRoleId(@Param("roleIds") List<Long> roleIds);

}
