package com.yizhi.system.application.mapper;

import java.util.List;

import com.yizhi.system.application.vo.CompanyVO;
import com.yizhi.system.application.domain.Company;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import com.baomidou.mybatisplus.mapper.BaseMapper;

/**
 * <p>
 * 企业管理 Mapper 接口
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
public interface CompanyMapper extends BaseMapper<Company> {

	
	/**
	 * 检查重复code的公司数量
	 * @param code
	 * @return
	 */
	@Select("select count(*)  from company where "
			+ "id <> #{id} and code = #{code} and status <> 3")
	int countExistCode(@Param(value="id") Long id,@Param(value="code") String code);
	
	/**
	 * 查询重code和name的站点数量
	 * @param id
	 * @param companyId
	 * @param code
	 * @return
	 */
	@Select("select count(*)  from company where "
			+ "id <> #{id} and name= #{name} and status <> 3")
	int countExistName(@Param(value="id") Long id,@Param(value="name") String name);
	
	@Select("select id from company where status=2")
	List<Long> getAllCompanyIds();
	
	/**
	 * 根据授权码获取企业信息
	 * @param authcode
	 * @return
	 */
	@Select("select a.id,a.code,a.name,a.auth_code,b.id AS rootOrgId "
			+ " from company a "
			+ " LEFT JOIN organization b ON a.id=b.company_id AND b.root_id=0 AND b.parent_id=0 "
			+ " where a.status=2 and a.auth_code = #{authcode}")
	CompanyVO findByAuthCode(@Param(value="authcode") String authcode);
}
