package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.system.application.request.SiteUnselectedResq;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.vo.SiteCompanyVO;
import com.yizhi.system.application.vo.SiteProtectDefinedVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 站点 Mapper 接口
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
public interface SiteMapper extends BaseMapper<Site> {
    /**
     * 查询重code的站点数量
     *
     * @param id
     * @param companyId
     * @param code
     * @return
     */
    @Select("select count(*)  from site where "
            + "id <> #{id} and code = #{code} and company_id= #{companyId}")
    int countExistCodeOrg(@Param(value = "id") Long id, @Param(value = "companyId") Long companyId, @Param(value = "code") String code);

    /**
     * 查询重name的站点数量
     *
     * @param id
     * @param companyId
     * @param name
     * @return
     */
    @Select("select count(*)  from site where "
            + "id <> #{id} and name = #{name} and company_id= #{companyId}")
    int countExistNameOrg(@Param(value = "id") Long id, @Param(value = "companyId") Long companyId, @Param(value = "name") String name);

    /**
     * 根据管辖区id获取对应的站点id
     *
     * @param userGroupIds
     * @param companyId
     * @param type 站点类型，可以为空
     * @return
     */
    List<Long> getIdsByUserGroupIds(@Param("userGroupIds") Set<Long> userGroupIds, @Param("companyId") Long companyId, @Param("type") int type);

    /**
     * 根据企业id查询站点code
     * @param companyId
     * @return
     */
    @Select("select code from site where company_id = #{companyId} and enabled = 1")
    Set<String> getSiteCode(@Param("companyId") Long companyId);

    @Select("select id from site")
    List<Long> getAllSiteId();
    
    @Select("select id from site where company_id = #{companyId} and enabled = 1")
    List<Long> getSiteIds(@Param("companyId") Long companyId);


    //条件查询站点列表
    List<SiteProtectDefinedVO> getSiteListByConditions(Page<SiteProtectDefinedVO> page, SiteUnselectedResq siteReq);


    List<SiteCompanyVO> getSiteListByIds(@Param("ids") List<Long> ids);

    Site selectSitebyCode(@Param("siteCode") String siteCode,@Param("companyCode") String companyCode);
}
