package com.yizhi.system.application.orm.interceptor;

import com.yizhi.system.application.vo.domain.Organization;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.*;

import java.lang.reflect.Method;
import java.util.Properties;

/**
 * @Author: shengchenglong
 * @Date: 2018/8/14 15:59
 */
//@Component
@Intercepts(
        {@Signature(type = Executor.class, method = "update", args = {MappedStatement.class, Object.class})}
)
public class MyInterceptor implements Interceptor {
    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        // query
        //        RoutingStatementHandler handler = (RoutingStatementHandler) invocation.getTarget();
        //
        //        StatementHandler delegate = (StatementHandler) ReflectUtil.getField(handler, "delegate");
        //        PreparedStatementHandler delegate = (PreparedStatementHandler) ReflectUtil.getField(handler, "delegate");
        // update
        final Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement) args[0];
        Long companyId = null;
        if (ms.getParameterMap().getType().getName().equals(Organization.class.getName())) {
            String commandName = ms.getSqlCommandType().name();
            Method method = invocation.getMethod();
            String name = method.getName();
        }

        return null;
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {

    }
}
