package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.AuthzRole;
import com.yizhi.system.application.vo.ManagerEditVo;
import com.yizhi.system.application.vo.ManagerVo;

import java.util.List;

public interface IAuthzRoleService extends IService<AuthzRole> {

    /**
     * 新增角色
     *
     * @param role
     */
    void add(AuthzRole role);

    /**
     * 更新角色
     *
     * @param role
     */
    void update(AuthzRole role);

    /**
     * 分页查询
     *
     * @param role
     * @param page
     */
    Page<AuthzRole> list(AuthzRole role, Page<AuthzRole> page);

    /**
     * 根据roleId查询关联的账户信息
     *
     * @param roleId
     * @return
     */
    List<Account> getAccountByRoleId(Long roleId);

    /**
     * 删除角色下关联的账户
     *
     * @param roleId
     * @param siteCode
     * @param accountId
     * @return
     */
    void delAccountByRoleId(Long roleId, String siteCode, Long accountId);

    /**
     * 删除角色
     *
     * @param role
     */
    void delete(AuthzRole role);

    /**
     * 检查code是否存在
     *
     * @param code
     */
    void checkExistCode(String code, Long siteId);

    /**
     * 检查名称是否存在
     *
     * @param name
     * @param siteId
     */
    void checkExistName(String name, Long siteId);

    /**
     * 角色授权用户
     *
     * @param roleId
     * @param siteCode
     * @param accountIds
     */
    void authAccount(Long roleId, String siteCode, List<Long> accountIds);

    /**
     * 查询角色详情
     *
     * @param id
     * @return
     */
    AuthzRole get(Long id);

    /**
     * 根据模块 code 查询角色（站点内的）
     *
     * @param companyId
     * @param moduleCode
     * @param accountId
     * @param siteId
     * @return
     */
    List<Long> getIdByModuleCodeInSite(Long companyId, Long siteId, Long accountId, String moduleCode);

    /**
     * 删除权限缓存
     *
     * @param companyCode
     * @param siteCode
     */
    void deleteAccountAuthzInfo(String companyCode, String siteCode);

    /**
     * 管理对象编辑
     *
     * @return
     */
    Boolean managerEdit(ManagerEditVo editVo);

    /**
     * 查看角色下的管理对象
     *
     * @param roleId
     * @return
     */
    List<ManagerVo> listManager(Long roleId);

    /**分页
     * 查看角色下的管理对象
     *
     * @param roleId
     * @return
     */
    Page<ManagerVo> pageManager(Long roleId,String keyWord,String position,Long orgId,String orgName,Integer pageNo,Integer pageSize);

}
