package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.system.application.domain.LoginLog;
import com.yizhi.system.application.vo.LoginDataStatisticsVO;
import com.yizhi.system.application.vo.LoginUserChartVO;
import com.yizhi.system.application.vo.LoginUserExportVO;
import com.yizhi.system.application.vo.LoginUserOrgExportVO;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 19:54 2018/8/28
 * @Modified By
 */
public interface ILoginExportService extends IService<LoginLog> {

    /**
     * 获取登陆情况的图表数据
     * @param startDate
     * @param endDate
     * @param type
     * @return
     */
    public List<LoginUserChartVO> loginLogChart(
            String startDate,
            String endDate,
            Integer type,
            Long cid,
            Long siteId,
            List<Long> orgs
    );

    /**
     * 根据组织获取登陆情况
     * @param startDate
     * @param endDate
     * @param kwd
     * @param pageSize
     * @param pageNo
     * @return
     */
    @GetMapping("/list/org")
    public Page<LoginUserOrgExportVO> loginLogByOrg(
            String startDate,
            String endDate,
            String kwd,
            Integer pageSize,
            Integer pageNo,
            Long cid,
            Long siteId,
            List<Long> orgs
    );

    /**
     * 根据用户获取登陆情况
     * @param startDate
     * @param endDate
     * @param kwd
     * @param pageSize
     * @param pageNo
     * @return
     */
    @GetMapping("/list/account")
    public Page<LoginUserExportVO> loginLogByAccount(
            String startDate,
            String endDate,
            String kwd,
            Integer pageSize,
            Integer pageNo,
            Long cid,
            Long siteId,
            List<Long> orgs,
            List<Long> siteAdminOrgs
    );
    
    public LoginDataStatisticsVO getLoginCountBySiteId(Long siteId);
}
