package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.model.ImportModel;
import com.yizhi.system.application.model.OrgImpModel;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.util.RightLeftIndex;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.util.application.tree.CommonTree;
import com.yizhi.system.application.vo.ReportOrgRespVO;
import com.yizhi.system.application.vo.RuleVisibleRangeVo;
import com.yizhi.system.application.vo.UpOrgVO;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <p>
 * 组织部门 服务类
 * </p>
 *
 * @author yinyuyan
 * @since 2018-03-08
 */
public interface IOrganizationService extends IService<Organization> {

    /**
     * 获取最大的排序+1
     * @param companyId
     * @param parentId
     * @return
     */
    int getMaxSort(long companyId, long parentId);
    /**
     * 根据名称
     *
     * @param name
     * @return
     */
    List<Organization> fuzzySearchByName(String name, Long companyId);

    /**
     * 新增组织机构
     *
     * @param organization
     * @return
     */
    boolean insertDetail(Organization organization);

    /**
     * 批量删除，删除包括所有子节点
     *
     * @param ids
     * @return
     */
    boolean batchDelete(Long[] ids, Long companyId);

    /**
     * 根据code查询
     *
     * @param code
     * @return
     */
    Organization findByCode(String code, Long companyId);

    /**
     * 分页，条件查询
     *
     * @param org
     * @param page
     * @return
     */
    Page<Organization> list(Organization org, Page<Organization> page);

    /**
     * 逻辑删除部门
     *
     * @param id
     * @return
     */
    Boolean delete(Long id, Long companyId);

    /**
     * 根据父节点查子部门（包含）
     *
     * @param parentId
     * @return
     */
    List<Organization> listChildren(Long parentId);

    /**
     * 查询指定部门及的子部门（包含）
     *
     * @param orgIds
     * @return
     */
    Set<Long> listChildrenId(Collection orgIds);

    /**
     * 查询指定部门的父部门，直到根（包含）
     *
     * @param orgId
     * @return
     */
    Set<Long> listParentIds(Long orgId);

    /**
     * 查询指定部门的父部门名称，直到根（包含）
     *
     * @param orgId
     * @return
     */
    List<String> listParentNameIds(Long orgId);

    /**
     * 查询指定部门的父部门，站点之内
     *
     * @param orgId
     * @param siteId
     * @return
     */
    Set<Long> listParentIdsInSite(Long orgId, Long siteId);

    /**
     * 查找code是否存在
     *
     * @param id
     * @param companyId
     * @param code
     * @return
     */
    Boolean countExistCodeOrg(Long id, Long companyId, String code);

    /**
     * 查找name是否存在
     *
     * @param id
     * @param companyId
     * @param name
     * @return
     */
    Boolean countExistNameOrg(Long id, Long companyId, String name);

    /**
     * 根据父节点id取根节点id(组织部门导入时用)
     *
     * @param parentId
     * @return
     */
    Long getRootIdByParentId(Long parentId);

    /**
     * 批量导入部门
     *
     * @param importModel
     * @return
     */
    List<OrgImpModel> orgImport(ImportModel importModel);

    /**
     * 获取公司内所有部门的code和id，key为code,value为id
     *
     * @param companyId
     * @return
     */
    Map<String, Long> getOrgMap(Long companyId);

    /**
     * 管理端：根据站点id获取当前站点下管辖范围的所有部门（包含层级）
     *
     * @param siteId
     * @param companyCode
     * @param siteCode
     * @return
     */
    Set<Long> getOrgIdsInSite(Long siteId, String companyCode, String siteCode);

    /**
     * 管理端：根据站点id获取当前站点下管辖范围的所有部门
     *
     * @param siteId
     * @param companyId
     * @param companyCode
     * @return
     */
    List<CommonTree> getBySiteId(Long siteId, Long companyId, String companyCode);

    /**
     * 根据角色id获取管理的组织（从redis中获取）
     *
     * @param roleIds
     * @param containSubOrg 是否包含子组织
     * @return
     */
    Set<Long> getByRoleId4IntersectionSet(List<Long> roleIds, boolean containSubOrg);

    /**
     *
     * @param roleIds
     * @param containSubOrg
     * @return
     */
    Set<Long> getByRoleId4UnionSet(List<Long> roleIds, boolean containSubOrg);

    /**
     * 根据组织列表查询组织人数信息
     *
     * @param orgs
     * @return
     */
    PageInfo<ReportOrgRespVO> getOrgsCountUser(List<Long> orgs, Integer pageNo, Integer pageSize, String orgCodeOrOrgName);

    /**
     * 查询管辖的组织
     *
     * @param requestContext
     * @return
     */
    List<Long> getMgrOrgs(RequestContext requestContext);


    /**
     * 获取父级组织
     *
     * @param orgId
     * @param companyId
     * @return
     */
    List<String> getOrgNames(Long orgId, Long companyId);

    /**
     * 根据组织id获取组织下的用户id列表
     *
     * @param orgId
     * @return
     */
    List<Long> getAccountsByOrgId(Long orgId);

    /**
     * 更新组织，如果有更改父部门id，其下所有的都要修改
     *
     * @param organization
     * @return
     */
    Boolean update(Organization organization) throws Exception;

    /**
     * 根据管辖区获取下面所有的部门
     *
     * @param companyId
     * @param groupId
     * @return
     */
    List<Organization> getByGroupId(Long companyId, Long... groupId);

    /**
     * 查询直接关联的
     *
     * @param groupId
     * @return
     */
    List<RightLeftIndex> getOrgRangeByGroupId(Long... groupId);

    /**
     * copy getIdsByGroupId   这个取得是交集
     * 当前类则取角色的人员范围的并集
     * 搜索用户，
     *
     * @param groupId
     * @return
     */
    List<RightLeftIndex> getOrgRangeByGroupIdNew(Long... groupId);

    /**
     * 根据管辖区获取下面所有的部门id，包含子部门
     *
     * @param companyId
     * @param groupId
     * @return
     */
    Set<Long> getIdsByGroupId(Long companyId, Long... groupId);

    /**
     * 根据组织id查询上一级的基本信息
     *
     * @param orgIds
     * @return
     */
    List<UpOrgVO> findupOrgsByOrgId(List<Long> orgIds);

    /**
     * 获取指定范围（站点，组织列表）的包含的组织ids
     *
     * @param siteId
     * @param orgIds
     * @param site
     * @return
     */
    Set<Long> getDestOrgIds(Long siteId, List<Long> orgIds, Site site);

    /**
     * 获取 父级部门名称-当前部门名称
     *
     * @return
     */
    Map<Long, String> getParentNameWithCurrentName(List<Long> orgIds);

    /**
     * 清除缓存
     *
     * @param companyId
     */
    void deleteCompanyInfo(Long companyId);

    Map<Long, String> getOrgNamesByOrgIds(List<Long> orgIds);

    Page getClassifyNameByDrools(String field,String value, Page page);

    /**
     * 根据规则条件查询包含子部门的orgIds
     */
    List<Long> getOrgIdsByName(RuleVisibleRangeVo rangeVo, Long companyId,Long ruleId);

    /**
     * 获取组织架构
     * @param orgId
     * @return
     */
    String getOrganizationNames(Long orgId);
}
