package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.system.application.domain.SensitiveWord;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author moni.yin123
 * @since 2018-04-08
 */
public interface ISensitiveWordService extends IService<SensitiveWord> {
	/**
	 * 新增敏感词
	 * @param sensitiveWord
	 * @return
	 */
	Boolean save(SensitiveWord sensitiveWord);
	/**
	 * 修改敏感词
	 * @param sensitiveWord
	 * @return
	 */
	Boolean update(SensitiveWord sensitiveWord);
	/**
	 * 删除敏感词
	 * @param id
	 * @return
	 */
	Boolean delete(Long id);
	/**
	 * 检查名称是否存在
	 * @param id
	 * @param companyId
	 * @param name
	 * @return
	 */
	Boolean checkName(Long id,Long companyId,String name);	
	/**
	 * 查询敏感词列表
	 * @param sensitiveWord
	 * @return
	 */
	Page<SensitiveWord> list(SensitiveWord sensitiveWord,Page<SensitiveWord> page);
}
