package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.core.application.enums.SmsSendBizType;
import com.yizhi.system.application.domain.SmsSendRecord;

/**
 * <p>
 * 短信发送记录表 服务类
 * </p>
 *
 * @author 谢海军123
 * @since 2018-12-06
 */
public interface ISmsSendRecordService extends IService<SmsSendRecord> {

    /**
     * 发送短信（可选参数，如果不填使用null）
     * @param templateParam 短信模板的占位参数替换（可选 如果短信模板没有占位参数，不要填）
     * @param smsUpExtendCode 可选-上行短信扩展码(扩展码字段控制在7位或以下，无特殊需求用户请忽略此字段) "90997"
     * @param outId 可选:outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
     * @param smsSendBizType 必填:发送短信的业务类型
     * @param phoneNumber 必填:待发送手机号。发送国际/港澳台消息时，接收号码格式为国际区号+号码，如85200000000;多个使用数组
     * @return
     */
    boolean sendSms( String templateParam, String smsUpExtendCode, Long businessLogo,
                     String outId, SmsSendBizType smsSendBizType
                    ,Long ... phoneNumber);

    boolean sendSms( String templateParam, String smsUpExtendCode, Long businessLogo,
                     String outId, SmsSendBizType smsSendBizType,String extend
            ,Long ... phoneNumber);

}
