package com.yizhi.system.application.service;

import com.yizhi.system.application.domain.SiteProtectNotice;
import com.yizhi.system.application.domain.dto.SiteProtectExportDTO;
import com.yizhi.system.application.request.QuerySiteProtectResq;
import com.yizhi.system.application.request.SiteProtectDelReq;
import com.yizhi.system.application.request.SiteProtectReq;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.system.application.vo.SiteProtectDetailVO;
import com.yizhi.system.application.vo.SiteProtectUserVO;
import com.yizhi.system.application.vo.SiteProtectVO;

import java.util.List;

public interface SiteProtectService {

    /**
     * 新增站点维护
     * @param siteProtectReq 站点维护实体
     * @return 新增成功返回站点唯一Id，否则返回null
     */
    Long addSiteProtect(SiteProtectReq siteProtectReq);

    /**
     * 修改站点维护
     * @param siteProtect 需要修改的站点维护数据
     * @return 修改成功返回该维护唯一id；否则返回null
     */
    Long updateSiteProtect(SiteProtectReq siteProtect);

    /**
     * 删除站点维护
     * @param protectDelReq  站点维护唯一id和通知id
     * @return 删除成功返回true，否则返回false
     */
    boolean deleteSiteProtect(SiteProtectDelReq protectDelReq);

    /**
     * 站点维护列表查询
     * @param querySiteProtectResq
     * @return
     */
    PageInfo<SiteProtectVO> queryList(QuerySiteProtectResq querySiteProtectResq);


    /**
     * 导出excel返回的内容列表
     * @param siteNoticeIdList
     * @return
     */
    List<SiteProtectExportDTO> list(List<Long> siteNoticeIdList);

    /**
     * 查询站点维护记录详情
     */
	SiteProtectDetailVO queryOne(Long id);

    /**
     * 根据站点code查询关站信息
     * @param siteCode
     * @param companyCode
     * @return
     */
	SiteProtectNotice findProtectNoticeBySiteCode(String siteCode, String companyCode);

    List<SiteProtectUserVO> getUserProtect(Long siteId,Long companyId);

}
