package com.yizhi.system.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.log.LogQueue;
import com.yizhi.core.application.log.TaskLogDetailEvent;
import com.yizhi.system.application.constant.AccountExportConditionConstant;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.constant.ImpAccountError;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.system.application.mapper.*;
import com.yizhi.system.application.model.AccountImpModel;
import com.yizhi.system.application.model.ImportModel;
import com.yizhi.system.application.service.*;
import com.yizhi.system.application.service.using.OrganizationCacheService;
import com.yizhi.system.application.service.using.OrganizationIndexService;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.date.DateUtil;
import com.yizhi.util.application.encrypt.ShaEncrypt;
import com.yizhi.util.application.regex.RegexUtil;
import com.yizhi.wechat.application.feign.WeiXinClient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Transactional(rollbackFor = Exception.class)
public class AccountImportServiceImpl extends ServiceImpl<AccountMapper, Account> implements IAccountImportService {

    private static final Logger logger = LoggerFactory.getLogger(AccountImportServiceImpl.class);
    @Autowired
    AccountMapper accountMapper;
    @Autowired
    AuthzAccountRoleMapper accountRoleMapper;
    @Autowired
    AuthzRoleMapper roleMapper;
    @Autowired
    IOrganizationService orgService;
    @Autowired
    SiteMapper siteMapper;
    @Autowired
    CompanyMapper companyMapper;
    @Autowired
    IdGenerator idGenerator;
    @Autowired
    AuthorityService authorityService;
    @Autowired
    AccountEnableLogMapper logMapper;
    @Autowired
    AuthzGroupMemberMapper memberMapper;
    @Autowired
    IAuthzUserGroupService groupService;
    @Autowired
    OrganizationMapper organizationMapper;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private AuthzGroupMemberMapper groupMemberMapper;
    @Autowired
    private OrganizationIndexService organizationIndexService;
    @Autowired
    private OrganizationCacheService organizationCacheService;
    @Autowired
    private AuthService authService;

    /*@Autowired
    RabbitTemplate rabbitTemplate;*/

    @Autowired
    RedisCache redisCache;

    @Autowired
    private ISmsSendRecordService smsSendRecordService;

    @Autowired
    private WeiXinClient weiXinClient;

    @Override
    public List<AccountImpModel> importAccount(ImportModel importModel, RequestContext context) {

        List<AccountImpModel> models = importModel.getData();
        // 获取企业的id
        Long companyId = context.getCompanyId();
        logger.info("当前用户的企业的companyId：" + companyId);
        // 获取当前企业的用户name 的列表
        List<String> names = accountMapper.selectNamesByCompanyId(companyId);

        logger.info("names size：" + names.size());

        names = names.parallelStream().map(name -> {
            return name.toLowerCase();
        }).collect(Collectors.toList());

        logger.info("names lowCase：" + names.size());
        Long taskId = importModel.getTaskId();

        if (CollectionUtils.isNotEmpty(models)) {
            List<TaskLogDetailEvent> failEvents = new ArrayList<TaskLogDetailEvent>();

            // 根组织
            Organization rootOrg = new Organization();
            rootOrg.setParentId(0L);
            rootOrg.setDeleted(Boolean.valueOf(false));
            rootOrg.setCompanyId(context.getCompanyId());
            EntityWrapper<Organization> rootOrgEw = new EntityWrapper(rootOrg);
            rootOrgEw.like("code", AuthzConstant.DEFAULT_COMPANY_ORG_ROOT_CODE_SUFFIX);
            rootOrg = rootOrg.selectOne(rootOrgEw);
            if (null == rootOrg) {
                failEvents.add(new TaskLogDetailEvent(taskId, "！！！查找根组织错误：未成功查询到根组织！！！"));
                //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
                return models;
            }

            List<Account> accounts = new ArrayList<Account>();

            // 文件中的用户名集合
            List<String> accountNamesInFile = new ArrayList<String>();
            List<String> newAaccountNamesInFile = new ArrayList<>();

            // 初始化文件中的手机号集合
            List<String> accountMobileInFile = new ArrayList<String>();

            // 初始化组织id
            Long orgId = null;

            List<Map<String, Long>> tempList = new ArrayList<Map<String, Long>>();
            // 存放已添加的节点数据
            Map<String, Map<String, Long>> orgMap = new HashMap<String, Map<String, Long>>();
            Map<String, Long> childOrgMap = new HashMap<String, Long>();
            Map<Long, String> parentIdLayerMap = new HashMap<>();
            //判断是否有新节点产生
            boolean isNewNode = false;
            boolean clearFlag = false;

            Long parentId;
            List<Account> updateAccountList = new ArrayList<Account>();

            // 初始化解绑集合
            List<Long> accountIds = new ArrayList<Long>(8);
            for (int j = 0; j < models.size(); j++) {
                AccountImpModel model = models.get(j);
                int i = j + 2;
                // 获取操作栏位的信息
                String operation = model.getOperation();
                boolean unBindUserFlag = false;
                if (StringUtils.isNotEmpty(operation)) {
                    unBindUserFlag = AccountExportConditionConstant.UNBIND_USER.equals(operation.trim());
                }
                // 判断操作是否解绑
                if (!unBindUserFlag) {
                    parentId = rootOrg.getId();
                    isNewNode = false;
                    childOrgMap = new HashMap<String, Long>();
                    //检查用组织不能为空
//                if (StringUtils.isEmpty(operation.trim())) {
                    if (StringUtils.isEmpty(model.getFullOrgName() != null ? model.getFullOrgName().trim() : model.getFullOrgName())) {
                        model.setResult(ImpAccountError.ORG_CODE_EMPTY);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.ORG_CODE_EMPTY));
                        continue;
                    }
//                }

                    // add 2018-7-17 10:00:14
                    String[] orgNameArray = model.getFullOrgName().trim().split("\\+");
                    // 子组织名不能和跟组织相同 add 2019年4月2日
                    int step = j + 2;
                    if (useArrayUtils(orgNameArray, rootOrg.getName())) {
                        model.setResult(ImpAccountError.ORGANIZATION_REPEAT);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + step + "行:" + ImpAccountError.ORGANIZATION_REPEAT));
                        continue;
                    }
                    orgNameArray = checkOrgImportCode(orgNameArray, rootOrg.getName().trim());
                    List<Organization> organizationList = new ArrayList<Organization>();
                    Date sysDate = new Date();

                    Organization midOrg = null;
                    String newOrgCode = null;
                    // 组织列表的新增
                    for (int k = 0; k < orgNameArray.length; k++) {
                        Long id = null;

                        if (!isNewNode && !orgMap.isEmpty()) {
                            if (orgMap.size() > 0 && orgMap.get(orgNameArray[0]) != null) {
                                parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k));
                                if (parentId != null) {
                                    if (k == 0) {
                                        parentId = rootOrg.getId();
                                    } else {
                                        parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k - 1));
                                    }

                                    orgId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k));
                                    if (k > 0) {
                                        if (k == 1) {
                                            logger.info("已存在组织：" + orgNameArray[k] + "_" + k + " 本节点ID:" +
                                                    orgMap.get(orgNameArray[0]).get(orgNameArray[k] + k) + " 父节点ID：" + parentId + "组织ID：" + orgId);
                                        } else {
                                            logger.info("已存在组织：" + orgNameArray[k] + "_" + k + " 本节点ID:" +
                                                    orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k)) + " 父节点ID：" + parentId + "组织ID：" + orgId);
                                        }

                                    }
                                    continue;
                                }
                            }
                        }
                        if (k == 0) {
                            parentId = rootOrg.getId();
                        } else {
                            parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k - 1));
                            logger.info("parentId:" + parentId);
                        }
                        midOrg = getOrg(orgNameArray[k], parentId);
                        if (midOrg != null) {
                            logger.info("已经存在导入组织的名称：" + k + "-层级-" + midOrg.getEnName());
                            logger.info("已经存在导入组织id：" + k + "-层级-" + midOrg.getId());
                            parentId = midOrg.getId();
                            orgId = parentId;
                            isNewNode = false;

                            if (k == 0) {
                                childOrgMap.put(getAllParentName(orgNameArray, k), orgId);
                                orgMap.put(orgNameArray[0], childOrgMap);
                                midOrg.setParentIdLayer(rootOrg.getId() + Organization.PARENT_ID_LAYER_SEPARATOR + midOrg.getId());
                                parentIdLayerMap.put(midOrg.getId(), midOrg.getParentIdLayer());
                            } else {
                                childOrgMap.put(getAllParentName(orgNameArray, k), orgId);
                                childOrgMap.putAll(orgMap.get(orgNameArray[0]));
                                orgMap.put(orgNameArray[0], childOrgMap);
                                midOrg.setParentIdLayer(parentIdLayerMap.get(midOrg.getParentId()) + Organization.PARENT_ID_LAYER_SEPARATOR + midOrg.getId());
                                parentIdLayerMap.put(midOrg.getId(), midOrg.getParentIdLayer());
                            }
                            continue;
                        } else {
                            Organization organization = new Organization();
                            id = idGenerator.generate();
                            logger.info("公司id：" + context.getCompanyId());
                            organization.setCompanyId(context.getCompanyId());
                            // 生成组织编码
                            // 获取redis中的编码值编码
                            String orgCode = redisCache.get(context.getCompanyCode()) + "";
                            if (orgCode != null && !"".equals(orgCode) && !"null".equals(orgCode)) {
                                // 新的组织编码
                                newOrgCode = (Integer.valueOf(orgCode) + 1) + "";
                                // 放到缓存中
                                redisCache.set(context.getCompanyCode(), newOrgCode);
                            } else {
                                newOrgCode = "1";
                                redisCache.set(context.getCompanyCode(), newOrgCode);
                            }
                            String orgNum = "";
                            switch (newOrgCode.length()) {
                                case 1:
                                    orgNum = "000" + newOrgCode;
                                    break;
                                case 2:
                                    orgNum = "00" + newOrgCode;
                                    break;
                                case 3:
                                    orgNum = "0" + newOrgCode;
                                    break;
                                default:
                                    orgNum = newOrgCode;
                            }
                            organization.setCode(context.getCompanyCode() + orgNum);
                            organization.setId(id);
                            organization.setName(orgNameArray[k].trim());
                            // 设置rootId
                            organization.setRootId(rootOrg.getId());
                            if (organization.getName().equals("理赔")) {
                                int uu = 0;
                                logger.info("理赔");
                            }
                            if (k == 0) {
                                organization.setParentId(rootOrg.getId());
                                organization.setParentIdLayer(rootOrg.getId() + Organization.PARENT_ID_LAYER_SEPARATOR + organization.getId());
                                parentIdLayerMap.put(organization.getId(), organization.getParentIdLayer());
                            } else {
                                if (k > 0) {
                                    parentId = orgMap.get(orgNameArray[0]).get(getAllParentName(orgNameArray, k - 1));
                                    logger.info("父级parentId：" + parentId);
                                }
                                organization.setParentId(parentId);
                                organization.setParentIdLayer(parentIdLayerMap.get(organization.getParentId()) + Organization.PARENT_ID_LAYER_SEPARATOR + organization.getId());
                                parentIdLayerMap.put(organization.getId(), organization.getParentIdLayer());
                            }
                            organization.setLayer(k + 1);
                            organization.setCreateTime(sysDate);
                            organization.setCreateByName(context.getAccountName());
                            organization.setCompanyId(context.getCompanyId());
                            organizationList.add(organization);
                            parentId = id;
                            orgId = id;
                            logger.info("组织的id：" + orgId);

                        }
                        //有新节点产生，那么它下面的子节点全部是新增加
                        isNewNode = true;
                        if (k == 0) {
                            childOrgMap.put(getAllParentName(orgNameArray, k), id);
                            orgMap.put(orgNameArray[0], childOrgMap);
                        } else {
                            childOrgMap.put(getAllParentName(orgNameArray, k), id);
                            childOrgMap.putAll(orgMap.get(orgNameArray[0]));
                            orgMap.put(orgNameArray[0], childOrgMap);
                        }
                        logger.info("添加新组织：" + orgNameArray[k] + "_" + k + ":" + id);
                    }

                    // 组织列表新增完成
                    if (organizationList != null && organizationList.size() > 0) {
                        // 批量新增组织
                        orgService.insertBatch(organizationList);
                        logger.info("organization add complete！");
                        clearFlag = true;
                    }


                    // 获取用户名
                    String name = model.getName();
                    logger.info("当前 current_name:" + name);

                    String workNum = model.getWorknum();

                    //检查用户名不能为空
                    if (StringUtils.isEmpty(name)) {
                        model.setResult(ImpAccountError.NAME_EMPTY);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_EMPTY));
                        continue;
                    }
                    // 转为小写
                    name = name.trim().toLowerCase();
                    // 获取用户名密码
                    String password = model.getPassword() != null ? model.getPassword().trim() : null;


                    if (StringUtils.isEmpty(operation)) {
                        //检查密码不能为空
                        if (StringUtils.isEmpty(password)) {
                            model.setResult(ImpAccountError.PASSWORD_EMPTY);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.PASSWORD_EMPTY));
                            continue;
                        }
                        //检查密码是否合法
                        if (!RegexUtil.checkAccountPassword(password.trim())) {
                            model.setResult(ImpAccountError.PASSWORD_FORMAT_ERROR);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.PASSWORD_FORMAT_ERROR));
                            continue;
                        }
                    }
                    //检查名称是否合法
                    if (StringUtils.isNotEmpty(name)) {
                        if (!RegexUtil.checkAccountName(name.trim())) {
                            model.setResult(ImpAccountError.NAME_FORMAT_ERROR);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_FORMAT_ERROR));
                            continue;
                        }
                    }

                    //检查手机是否合法
                    String phone = model.getMobile();
                    if (StringUtils.isNotEmpty(phone)) {
                        if (!RegexUtil.checkMobile(phone.trim())) {
                            model.setResult(ImpAccountError.PHONE_FORMAT_ERROR);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.PHONE_FORMAT_ERROR));
                            continue;
                        }
                    }
                    //检查邮箱是否合法
                    String email = model.getEmail();
                    if (StringUtils.isNotEmpty(email.trim())) {
                        if (!RegexUtil.checkEmail(email.trim())) {
                            model.setResult(ImpAccountError.EMAIL_FORMAT_ERROR);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.EMAIL_FORMAT_ERROR));
                            continue;
                        }
                    }
                    //判断备注 add by ly 2019-4-4 11:28:18
                    String remarkFirst = model.getRemarkFirst();
                    logger.info("remarkFirst的值是：" + remarkFirst);
                    if (StringUtils.isNotEmpty(remarkFirst)) {
                        if (!RegexUtil.isSuccessRemark(remarkFirst.trim())) {
                            model.setResult(ImpAccountError.REMARK_REQUIRED);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_REQUIRED));
                            continue;
                        }
                        if ((remarkFirst.trim()).length() > 50) {
                            model.setResult(ImpAccountError.REMARK_LENGTH);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_LENGTH));
                            continue;
                        }
                    }

                    String remarkSecond = model.getRemarkSecond();
                    if (StringUtils.isNotEmpty(remarkSecond)) {
                        if (!RegexUtil.isSuccessRemark(remarkSecond.trim())) {
                            model.setResult(ImpAccountError.REMARK_REQUIRED);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_REQUIRED));
                            continue;
                        }
                        if ((remarkSecond.trim()).length() > 50) {
                            model.setResult(ImpAccountError.REMARK_LENGTH);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_LENGTH));
                            continue;
                        }
                    }

                    String remarkThird = model.getRemarkThird();
                    if (StringUtils.isNotEmpty(remarkThird)) {
                        if (!RegexUtil.isSuccessRemark(remarkThird.trim())) {
                            model.setResult(ImpAccountError.REMARK_REQUIRED);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_REQUIRED));
                            continue;
                        }

                        if ((remarkThird.trim()).length() > 50) {
                            model.setResult(ImpAccountError.REMARK_LENGTH);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.REMARK_LENGTH));
                            continue;
                        }
                    }


                    //  判断导入用户 2019-2-28

                    List<String> mobileList = accountMapper.selectMobilesByCompanyId(companyId);
                    String newName = "";
                    if (StringUtils.isEmpty(operation)) {

                        // 检查文件中是否有重名
                        if (accountNamesInFile.contains(name.toLowerCase())) {
                            model.setResult(ImpAccountError.NAME_EXIST_IN_FILE);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_EXIST_IN_FILE));
                            continue;
                        }
                        accountNamesInFile.add(name.toLowerCase());
                        //检查名称是否重复
                        // modified by shengchenglong，不区分大小写
                        if (names.contains(name.toLowerCase())) {
                            model.setResult(ImpAccountError.NAME_EXIST);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_EXIST));
                            continue;
                        }
                        names.add(name.toLowerCase());

                        // 新增用户
                        //检查手机号是否重复
                        if (StringUtils.isNotEmpty(phone)) {
                            if (accountMapper.countExistMobile(0L, context.getCompanyId(), phone.trim()) > 0) {
                                model.setResult(ImpAccountError.MOBILE_EXIST);
                                failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.MOBILE_EXIST));
                                continue;
                            }
                            mobileList.add(phone);
                        }

                    } else {
                        if (AccountExportConditionConstant.UPDATE_NAME.equals(operation.trim())) {
                            logger.info("name" + name);
                            logger.info("" + names);
                            if (!names.contains(name)) {
                                model.setResult(ImpAccountError.MODIFY_NAME_NOT_EXIST);
                                failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.MODIFY_NAME_NOT_EXIST));
                                continue;
                            }
                            Account userInfo = new Account();
                            userInfo.setName(model.getName().trim());
                            userInfo.setCompanyId(companyId);
                            Account account = this.selectOne(QueryUtil.condition(userInfo));


                            if (!StringUtils.isNotEmpty(account.getMobile())) {
                                if (StringUtils.isNotEmpty(phone)) {
                                    if (!phone.equals(account.getMobile())) {
                                        if (mobileList.contains(phone)) {
                                            model.setResult(ImpAccountError.MOBILE_EXIST);
                                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.MOBILE_EXIST));
                                            continue;
                                        }
                                    }
                                }
                            }

                            newName = model.getNewName().trim();

                            if (StringUtils.isNotEmpty(newName)) {
                                logger.info("当前的新名称：" + newName);
                                boolean flag = RegexUtil.checkAccountName(newName.trim());
                                logger.info("校验的结果：" + flag);
                                // 校验新用户名的格式
                                if (!RegexUtil.checkAccountName(newName.trim())) {
                                    model.setResult(ImpAccountError.NEW_NAME_FORMAT_ERROR);
                                    failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NEW_NAME_FORMAT_ERROR));
                                    continue;
                                }

                                newName = newName.toLowerCase();
                                // 检查文件中是否有重名
                                if (newAaccountNamesInFile.contains(newName)) {
                                    model.setResult(ImpAccountError.NEW_NAME_EXIST_IN_FILE);
                                    failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NEW_NAME_EXIST_IN_FILE));
                                    continue;
                                }
                                newAaccountNamesInFile.add(model.getNewName());

                                //检查名称是否和数据库中的名称重复
                                if (names.contains(model.getNewName())) {
                                    model.setResult(ImpAccountError.NAME_EXIST);
                                    failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_EXIST));
                                    continue;
                                }
                                names.add(name);
                            }

                        }
                    }

                    // 判断文件中手机号是否重复
                    if (StringUtils.isNotEmpty(phone)) {
                        if (accountMobileInFile.contains(phone)) {
                            model.setResult(ImpAccountError.MOBILE_EXIST_IN_FILE);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.MOBILE_EXIST_IN_FILE));
                            continue;
                        }
                    }
                    accountMobileInFile.add(phone);
                    String fullName = model.getFullName();
                    if (StringUtils.isNotEmpty(fullName)) {
                        if ((fullName.trim()).length() > 20) {
                            model.setResult(ImpAccountError.FULLNAME_LENGTH_LONG);
                            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.FULLNAME_LENGTH_LONG));
                            continue;
                        }
                        mobileList.add(phone);
                    }

                    String enable = model.getEnabled();
                    Boolean enabled = null;
                    if (StringUtils.isNotEmpty(enable)) {
                        if ("1".equals(enable)) {
                            enabled = Boolean.TRUE;
                        } else if ("0".equals(enable)) {
                            enabled = Boolean.FALSE;
                        }
                    }
                    //查询账号过期类型
                    Integer expiredType = 0;
                    String validDate = model.getValidDate();
                    Date startDate = null;
                    Date endDate = null;
                    Date expiredTime = null;
                    Integer validDays = 0;
                    try {
                        if (org.apache.commons.lang3.StringUtils.EMPTY.equals(org.apache.commons.lang3.StringUtils.trimToEmpty(validDate))) {
                            expiredType = 1;
                        } else {
                            if (validDate.indexOf("-") != -1) {
                                String[] dateArr = validDate.split("-");
                                if (dateArr.length < 2) {
                                    model.setResult(ImpAccountError.VALIDDATE_FORMAT_ERROR);
                                    failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.VALIDDATE_FORMAT_ERROR));
                                    continue;
                                } else {
                                    expiredType = 2;
                                    startDate = DateUtil.parseShort(dateArr[0]);
                                    endDate = DateUtil.parseShort(dateArr[1]);
                                }
                            } else {
                                expiredType = 3;
                                validDays = Integer.parseInt(validDate);
                                Calendar cal = Calendar.getInstance();
                                //根据有效天数计算账号过期时间
                                cal.add(Calendar.DATE, validDays);
                                expiredTime = cal.getTime();
                            }
                        }
                    } catch (Exception e) {
                        model.setResult(ImpAccountError.VALIDDATE_FORMAT_ERROR);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.VALIDDATE_FORMAT_ERROR));
                        continue;
                    }
                    Account account = new Account();
                    account.setId(idGenerator.generate());
                    account.setName(name.trim());
                    account.setCompanyId(companyId);
                    account.setEmail(email);
                    account.setMobile(phone);
                    account.setTelephone(phone);
                    account.setWorkNum(workNum);
                    account.setExpiredType(expiredType);
                    account.setStartTime(startDate);
                    account.setEndTime(endDate);
                    account.setExpiredTime(expiredTime);
                    account.setValidDays(validDays);
                    account.setOrgId(orgId);
                    logger.info("导入用户的用户组织id");
                    account.setFullName(model.getFullName());
                    account.setPosition(model.getPosition());
                    account.setCreateById(importModel.getAccountId());
                    account.setCreateByName(importModel.getAccountName());
                    account.setCreateTime(new Date());
                    // add by ly 2019-4-4 11:13:27
                    account.setRemarkFirst(model.getRemarkFirst());
                    account.setRemarkSecond(model.getRemarkSecond());
                    account.setRemarkThird(model.getRemarkThird());

                    // 判断导入用户还是新增用户
                    logger.info("当前导入操作：" + operation.trim());
                    if (StringUtils.isEmpty(operation)) {
                        // 新增用户
                        account.setPassword(ShaEncrypt.encryptNewPassword(password));
                        accounts.add(account);
                    } else {
                        if (AccountExportConditionConstant.UPDATE_NAME.equals(operation.trim())) {

                            try {
                                // 获取用户信息
                                Account updateAccount = new Account();

                                updateAccount.setName(name);
                                updateAccount.setCompanyId(companyId);
                                // 获取当前的用户的信息
                                updateAccount = this.selectOne(QueryUtil.condition(updateAccount));
                                logger.info("返回用户：" + updateAccount);
                                // 密码校验
                                if (StringUtils.isNotEmpty(password)) {
                                    //检查密码是否合法
                                    if (!RegexUtil.checkAccountPassword(password.trim())) {
                                        model.setResult(ImpAccountError.PASSWORD_FORMAT_ERROR);
                                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.PASSWORD_FORMAT_ERROR));
                                        continue;
                                    }
                                    account.setPassword(ShaEncrypt.encryptNewPassword(password));
                                }
                                //更新部门校验部门为空，不修改

                                if (StringUtils.isEmpty(model.getFullOrgName() != null ? model.getFullOrgName().trim() : model.getFullOrgName())) {
                                    account.setOrgId(updateAccount.getOrgId());
                                }


                                if (updateAccount != null) {
                                    logger.info("用户id：" + updateAccount.getId());
                                    if (enabled != null) {
                                        account.setEnabled(enabled);
                                        if (enabled) {
                                            account.setEnabledTime(new Date());
                                        }
                                    }
                                    account.setId(updateAccount.getId());
                                    // 可修改用户的名 add 2019年7月25日11:28:26 by lingye
                                    String new_name = StringUtils.isNotEmpty(newName) ? newName : name;
                                    account.setName(new_name);
                                }
                                account.setCreateTime(null);
                                account.setUpdateTime(new Date());
                                updateAccountList.add(account);
                            } catch (Exception e) {
                                logger.info("更新异常{}", e);
                            }
                        }
                    }

//                解绑用户
                } else if (unBindUserFlag) {
                    String name = model.getName();
                    logger.info("解绑的用户名:" + name);

                    if (StringUtils.isEmpty(name)) {
                        model.setResult(ImpAccountError.NAME_EMPTY);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.NAME_EMPTY));
                        continue;
                    }

                    if (!names.contains(name)) {
                        model.setResult(ImpAccountError.UNBIND_NAME_NOT_EXIST);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.UNBIND_NAME_NOT_EXIST));
                        continue;
                    }
                    Account userInfo = new Account();
                    userInfo.setName(model.getName().trim());
                    userInfo.setCompanyId(companyId);
                    Account account = this.selectOne(QueryUtil.condition(userInfo));
                    if (account == null) {
                        model.setResult(ImpAccountError.UNBIND_NAME_NOT_EXIST);
                        failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImpAccountError.UNBIND_NAME_NOT_EXIST));
                        continue;
                    }
                    accountIds.add(account.getId());

                }

            }

            if (CollectionUtils.isNotEmpty(accountIds)) {
                // 解绑用户
                Boolean unbindUserResult = weiXinClient.unbindUser(accountIds);
                if (CollectionUtils.isNotEmpty(failEvents)) {
                    //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
                }
                return models;
            }
            if (CollectionUtils.isNotEmpty(accounts)) {
                if (!this.insertBatch(accounts)) {
                    throw new BizException(ReturnCode.SAVE_FAIL.getCode(), ReturnCode.SAVE_FAIL.getMsg());
                }
                clearFlag = true;
            }
            // 更新用户信息
            if (CollectionUtils.isNotEmpty(updateAccountList)) {

                if (!this.updateBatchById(updateAccountList)) {
                    throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
                }
                clearFlag = true;
            }


            if (clearFlag) {
                Company company = companyMapper.selectById(companyId);
                if (company!=null){
                    // 计算左右索引
                    organizationIndexService.addInitTask(companyId);
                }
            }
            //错误的信息发送给任务详情表
            if (CollectionUtils.isNotEmpty(failEvents)) {
               // rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
            }
            return models;
        } else {
            throw new BizException(ReturnCode.RESOURCE_NOT_FOUND.getCode(), ReturnCode.RESOURCE_NOT_FOUND.getMsg());
        }
    }

    /**
     * 获取当前节点的所有父亲节点
     *
     * @param orgNameArray
     * @param curIndex
     * @return
     */
    private String getAllParentName(String[] orgNameArray, int curIndex) {
        String name = "";
        for (int i = 0; i < curIndex + 1; i++) {
            name += orgNameArray[i];
        }
        return name + curIndex;
    }

    /**
     * 数组包含
     *
     * @param arr
     * @param targetValue
     * @return
     */
    public boolean useArrayUtils(String[] arr, String targetValue) {
        return ArrayUtils.contains(arr, targetValue);
    }


    /**
     * 去除跟组织
     *
     * @param fullOrgName
     * @param rootName
     * @return
     */
    private String[] checkOrgImportCode(String[] fullOrgName, String rootName) {
        if (fullOrgName[0].equals(rootName)) {
            return Arrays.copyOfRange(fullOrgName, 1, fullOrgName.length);
        }
        return fullOrgName;
    }

    /**
     * 查询组织
     *
     * @param name
     * @param parentId
     * @return
     */
    public Organization getOrg(String name, Long parentId) {
        Organization org = new Organization();
        org.setName(name.trim());
        org.setParentId(parentId);
        org.setDeleted(false);
        return orgService.selectOne(QueryUtil.condition(org));
    }
}
