package com.yizhi.system.application.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.AuthzGroupMember;
import com.yizhi.system.application.domain.AuthzMenu;
import com.yizhi.system.application.domain.AuthzRole;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.exception.AuthNoManagementException;
import com.yizhi.system.application.exception.AuthNotManageException;
import com.yizhi.system.application.mapper.AccountMapper;
import com.yizhi.system.application.mapper.AuthzGroupMemberMapper;
import com.yizhi.system.application.mapper.AuthzMenuMapper;
import com.yizhi.system.application.mapper.AuthzResourceMapper;
import com.yizhi.system.application.mapper.AuthzRoleManagerMapper;
import com.yizhi.system.application.mapper.AuthzRoleMapper;
import com.yizhi.system.application.mapper.AuthzRoleUserGroupMapper;
import com.yizhi.system.application.mapper.OrganizationMapper;
import com.yizhi.system.application.mapper.SiteMapper;
import com.yizhi.system.application.model.AccessSite;
import com.yizhi.system.application.model.AuthAccountSiteModel;
import com.yizhi.system.application.service.AuthService;
import com.yizhi.system.application.service.AuthorityService;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.IAuthzRoleService;
import com.yizhi.system.application.service.IAuthzUserGroupService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.util.HQInManageParam;
import com.yizhi.system.application.util.OrgIndexUtil;
import com.yizhi.system.application.util.RightLeftIndex;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.HQAccountInManageParam;
import com.yizhi.system.application.vo.practice.AccountOrgVo;
import com.yizhi.system.application.vo.practice.OrgAccountVo;
import com.yizhi.util.application.json.JsonUtil;
import com.yizhi.util.application.tree.CommonTree;
import com.yizhi.util.application.tree.TreeUtil;

/**
 * @Author: shengchenglong
 * @Date: 2018/5/18 11:37
 */
@Service
public class AuthServiceImpl implements AuthService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AuthServiceImpl.class);

    @Value("${redis.manage.authz.expired}")
    private Long redisManageAuthzExpired;

    @Autowired
    private AuthzRoleMapper roleMapper;
    @Autowired
    private AccountMapper accountMapper;
    @Autowired
    private AuthzGroupMemberMapper groupMemberMapper;
    @Autowired
    private SiteMapper siteMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private AuthzResourceMapper operationMapper;
    @Autowired
    private AuthzMenuMapper authzMenuMapper;
    @Autowired
    private AuthzRoleManagerMapper authzRoleManagerMapper;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private IAuthzRoleService roleService;
    @Autowired
    private IAuthzUserGroupService groupService;
    @Autowired
    private IAccountService accountService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private AuthzRoleUserGroupMapper authzRoleUserGroupMapper;
    @Autowired
    private IAccountService iAccountService;
    @Autowired
    private AuthorityService authorityService;


    @Deprecated
    @Override
    public List<Site> getAccessSite(Long accountId) {
        List<AuthzRole> roles = roleMapper.getByAccountId(accountId);
        Set<Long> siteIds = new HashSet<>();
        // 循环角色，寻找站点
        if (!CollectionUtils.isEmpty(roles)) {
            for (AuthzRole role : roles) {
                siteIds.add(role.getSiteId());
            }

            if (!CollectionUtils.isEmpty(siteIds)) {
                return siteMapper.selectBatchIds(siteIds);
            }
        }
        return null;
    }

    @Cacheable(value = "auth:manage", key = "'company:' + #companyId + ':account:' + #accountId + ':sites'")
    @Override
    public Set<Long> AccessSiteIds(Long companyId, Long accountId) {
        List<AuthzRole> roles = roleMapper.getByAccountId(accountId);
        Set<Long> siteIds = new HashSet<>();
        // 循环角色，寻找站点
        if (!CollectionUtils.isEmpty(roles)) {
            for (AuthzRole role : roles) {
                siteIds.add(role.getSiteId());
            }
        }
        return siteIds;
    }

    @Cacheable(value = "auth:manage", key = "'company:' + #companyId + ':account:' + #accountId + ':site:' + #siteId + ':SiteAutho'")
    @Override
    public AuthAccountSiteModel getSiteAutho(String companyCode, Long companyId, Long accountId, Long siteId, String key) {
        if (key.equalsIgnoreCase(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_MANAGERIDS)) {
            return getHQManagerModel(companyCode, companyId, accountId, siteId);
        }

        if (key.equalsIgnoreCase(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ORGIDS)) {
            return getHQOrgModel(companyCode, companyId, accountId, siteId);
        }
        return null;
    }

    @Cacheable(value = "auth:front", key = "'company:' + #companyId + ':account:' + #accountId + ':sites'")
    @Override
    public Set<Long> AccessSiteIdsFront(Long companyId, String companyCode, Long accountId) {
        Set<Long> siteIds = new HashSet<>();
        // 从缓存中拿取
        Object object = redisCache.hget(CacheNamespace.REDIS_AUTHZ_FRONT_COMPANY_ACCOUNT_ACCESS_SITE + companyCode,
                String.valueOf(accountId));
        if (null != object) {
            siteIds.addAll(JsonUtil.json2List(object.toString(), Long.class));
            return siteIds;
        }
        // 缓存未命中
        // 1. 默认站点，企业下所有人员都可以访问
        Account account = accountMapper.selectById(accountId);


        // 1. 查询角色
        List<AuthzRole> roles = roleMapper.getByAccountId(accountId);

        if(!CollectionUtils.isEmpty(roles)) {
            List<Long> siteIdList = roles.stream().map(AuthzRole::getSiteId).distinct().collect(Collectors.toList());
            siteIds.addAll(siteIdList);
        }

        Site site = new Site();
        site.setCompanyId(account.getCompanyId());
        site.setEnabled(Boolean.valueOf(true));
        site.setType(AuthzConstant.SITE_TYPE_DEFAULT);
        site = siteMapper.selectOne(site);

        if (site != null) {
            siteIds.add(site.getId());
        }

        // 2. 非默认站点判断管辖区, 查出所在管辖区id
        Organization organization = organizationMapper.selectById(account.getOrgId());
        if (null != organization) {
            // 1. 查出当前部门的所有父部门
            Set<Long> parentIds = organizationService.listParentIds(organization.getId());
            // 2. 查出该用户所在管辖区id
            Set<Long> userGroupIdsFront = groupMemberMapper.getIdsByAccountOrgId(accountId, parentIds);
            if (!CollectionUtils.isEmpty(userGroupIdsFront)) {
                List<Long> ids = siteMapper.getIdsByUserGroupIds(userGroupIdsFront, companyId, AuthzConstant.SITE_TYPE_SUB);
                if (!CollectionUtils.isEmpty(ids)) {
                    siteIds.addAll(ids);
                }
            }
        }
        try {
            redisCache.hset(CacheNamespace.REDIS_AUTHZ_FRONT_COMPANY_ACCOUNT_ACCESS_SITE + companyCode,
                    String.valueOf(accountId), JSON.toJSONString(siteIds),
                    redisManageAuthzExpired);
        } catch (Exception e) {
            LOGGER.error("用户可以访问学员端站点放入redis错误：try-catch处理，不影响返回", e);
        }
        return siteIds;
    }

    @Cacheable(value = "auth:front", key = "'company:' + #companyId + ':account:' + #accountId + ':relationIds'")
    @Override
    public List<Long> getRelationIds(Long companyId, Long accountId, Long siteId) {
        Account account = accountMapper.selectById(accountId);
        if (null != account) {
            Site site = siteMapper.selectById(siteId);
            if (null != site) {
                Organization organization = organizationMapper.selectById(account.getOrgId());
                if (null != organization) {
                    List<Long> relationIds = new ArrayList<>();
                    relationIds.add(accountId);
                    // 1. 如果是总站点，可以看到该用户所在 部门A 以及 部门A上级部门 的东西
                    if (site.getType().equals(AuthzConstant.SITE_TYPE_DEFAULT)) {
                        relationIds.addAll(organizationService.listParentIds(organization.getId()));
                    }
                    // 2. 如果是子站点，可以看到该用户所在 部门A 以及 部门A在该站点下的上级部门 的东西
                    else {
                        Set<Long> set = organizationService.listParentIdsInSite(organization.getId(), siteId);
                        if (!CollectionUtils.isEmpty(set)) {
                            relationIds.addAll(set);
                        }
                    }
                    return relationIds;
                }
            }
        }
        return null;
    }

    @Cacheable(value = "auth:manage", key = "'company:' + #companyId + ':account:' + #accountId + ':siteId:' + #siteId + ':sites'")
    @Override
    public List<AccessSite> getAccessSiteWithMenu(String companyCode, Long accountId, Long siteId)
            throws AuthNoManagementException, AuthNotManageException {
        // 从redis中查出
        Object object = redisCache.hget(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ACCOUNT_ACCESS_SITE + companyCode,
                String.valueOf(accountId));
        if (null != object) {
            List<AccessSite> accessSites = JsonUtil.json2List(object.toString(), AccessSite.class);
            return accessSites;
        }

        // 1. 查询角色
        List<AuthzRole> roles = roleMapper.getByAccountId(accountId);

        // 2. 循环角色，组装map
        if (!CollectionUtils.isEmpty(roles)) {
            // 站点id -- 角色 map
            Map<Long, Set<AuthzRole>> siteRoleMap = new HashMap<>();
            // 站点id -- 站点 map
            Map<Long, Site> siteMap = new HashMap<>();

            for (AuthzRole role : roles) {
                // 如果站点下角色集合为空
                if (CollectionUtils.isEmpty(siteRoleMap.get(role.getSiteId()))) {
                    Set<AuthzRole> roleSet = new HashSet<>();
                    roleSet.add(role);
                    siteRoleMap.put(role.getSiteId(), roleSet);
                } else {
                    siteRoleMap.get(role.getSiteId()).add(role);
                }
            }

            // 管理站点范围中没有当前站点，不是该站点的管理员，无权访问该站点
            if (!siteRoleMap.keySet().contains(siteId)) {
                throw new AuthNotManageException();
            }
            Site siteEx = new Site();
            siteEx.setEnabled(true);
            EntityWrapper<Site> siteEW = new EntityWrapper<>(siteEx);
            siteEW.in("id", siteRoleMap.keySet());
            List<Site> sites = siteMapper.selectList(siteEW);
            // 组装 站点id -- 站点 map
            for (Site site : sites) {
                siteMap.put(site.getId(), site);
            }

            // 开始
            List<AccessSite> accessSites = new ArrayList<>();
            Set<Long> roleIds = null;
            boolean isAdmin = false;
            for (Map.Entry<Long, Set<AuthzRole>> entry : siteRoleMap.entrySet()) {
                if (!siteMap.keySet().contains(entry.getKey())) {
                    //剔除无效站点
                    continue;
                }
                roleIds = new HashSet<>();
                isAdmin = false;

                AccessSite accessSite = new AccessSite();
                accessSite.setSiteId(entry.getKey());
                accessSite.setSiteCode(siteMap.get(entry.getKey()).getCode());
                accessSite.setSiteName(siteMap.get(entry.getKey()).getName());
                accessSite.setLogo(siteMap.get(entry.getKey()).getLogo());

                for (AuthzRole role : entry.getValue()) {
                    // 如果是站点管理员，所有菜单
                    if (role.getCode().equals(siteMap.get(entry.getKey()).getCode() + AuthzConstant.DEFAULT_SITE_ADMIN_ROLE_CODE_SUFFIX)) {
                        // 查询出所有菜单，并组装树形结构
                        AuthzMenu menu = new AuthzMenu();
                        menu.setOperationMenu(siteMap.get(entry.getKey()).getOperationSite() == true ? null : false);
                        menu.setDefaultSiteOnly(siteMap.get(entry.getKey()).getType().equals(AuthzConstant.SITE_TYPE_DEFAULT) ? null : false);
                        menu.setEnabled(1);
                        menu.setDeleted(0);//删除的菜单在这里不显示

                        EntityWrapper<AuthzMenu> ew = new EntityWrapper<>(menu);
                        //  菜单排序
                        ew.orderBy("sort", true);
                        List<AuthzMenu> menus = authzMenuMapper.selectList(ew);
                        accessSite.setMenus(buildTree(menus));
                        isAdmin = true;
                        break;
                    }
                    // 如果是普通业务管理员
                    else {
                        roleIds.add(role.getId());
                    }
                }
                // 如果不是站点管理员，需要组建菜单
                if (!isAdmin) {
                    if (CollectionUtils.isEmpty(roleIds)){
                        LOGGER.error("非站点管理员，组建菜单失败，roleIds为空");
                        return accessSites;
                    }
                    accessSite.setMenus(buildTree(authzMenuMapper.getMenu(roleIds)));
                }
                accessSites.add(accessSite);
            }
            // 放入redis中
            redisCache.hset(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ACCOUNT_ACCESS_SITE + companyCode,
                    String.valueOf(accountId),
                    JSON.toJSONString(accessSites),
                    redisManageAuthzExpired);
            return accessSites;
        }
        // 没有任何角色，无法访问任何站点
        else {
            throw new AuthNoManagementException();
        }
    }

    @Override
    public Set<Long> getAccountIdsInManage(Site site, RequestContext context, AuthzConstant.moduleType moduleType) {
        HQAccountInManageParam param = new HQAccountInManageParam();
        param.setAccountId(context.getAccountId());
        param.setModuleType(moduleType);

        Company company = new Company();
        company.setId(site.getCompanyId());
        company = company.selectById();

        Long accountId = context.getAccountId();
        Long siteId = site.getId();


        AuthAccountSiteModel authAccountModel = null;
        Object object = redisCache.hget(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_MANAGERIDS.concat(company.getCode()), site.getCode().concat(CacheNamespace.REDIS_HASH_SEPARATOR).concat(String.valueOf(accountId)));
        if (object == null) {
            authAccountModel = this.getSiteAutho(company.getCode(), company.getId(), accountId, siteId, CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ORGIDS);
        } else {
            authAccountModel = JsonUtil.json2Ojbect(object.toString(), AuthAccountSiteModel.class);
        }
        boolean allCompany = false;

        // 1. 站点管理员 管理全站点
        if (authAccountModel.getSiteAdmin()) {
            // 1.1 如果是默认站点
            if (site.getType().equals(AuthzConstant.SITE_TYPE_DEFAULT)) {
                return new HashSet<>(accountMapper.getIdByCompanyId(company.getId()));
            }
            // 1.2 不是默认站点
            List<Long> orgIds = groupMemberMapper.getMemberIdsByGroupId(1, site.getUserGroupId());
            List<Long> accountIds = groupMemberMapper.getMemberIdsByGroupId(2, site.getUserGroupId());
            List<RightLeftIndex> indices = OrgIndexUtil.getChildrenRange(organizationMapper.selectBatchIds(orgIds));
            return new HashSet<>(accountService.getAccountId(company.getId(), true, null, null, indices, accountIds));
        }
        // 2. 分级授权管理员，
        HQInManageParam hqInManageParam = this.getHQInManageParam(accountId, site, moduleType);
        if (hqInManageParam == null) {
            return null;
        }
        // 2. 如果管理了根部门，相当于站点管理员，可见范围为全企业
        if (hqInManageParam.getContainRootOrg()) {
            return new HashSet<>(accountMapper.getIdByCompanyId(company.getId()));
        }
        // 3. 没有根部门，则查询指定的管辖区指定的范围
        if (CollectionUtils.isEmpty(hqInManageParam.getAccountIds()) && CollectionUtils.isEmpty(hqInManageParam.getIndices())) {
            return null;
        }
        return new HashSet<>(accountService.getAccountId(company.getId(), true, null, null, hqInManageParam.getIndices(), hqInManageParam.getAccountIds()));
    }

    @Override
    public HQInManageParam getHQInManageParam(Long accountId, Site site, AuthzConstant.moduleType moduleType) {
        List<Long> groupIds = authzRoleUserGroupMapper.getGroupIdByParam(accountId, moduleType.name(), site.getId());
        if (!CollectionUtils.isEmpty(groupIds)) {
            EntityWrapper<AuthzGroupMember> ew = new EntityWrapper<>();
            ew.in("group_id", groupIds);
            ew.eq("deleted",0);
            List<AuthzGroupMember> members = groupMemberMapper.selectList(ew);
            if (!CollectionUtils.isEmpty(members)) {
                HQInManageParam param = new HQInManageParam();
                List<Long> orgIds = new ArrayList<>();
                members.forEach(item -> {
                    if (item.getType().equals(AuthzConstant.GROUP_MEMBER_TYPE_ORG)) {
                        orgIds.add(item.getMemberId());
                    } else {
                        param.getAccountIds().add(item.getMemberId());
                    }
                });
                if (!CollectionUtils.isEmpty(orgIds)) {
                    Organization rootOrg = getRootOrg(site.getCompanyId());
                    // 如果关联了根部门，那么相当于站点管理员
                    if (orgIds.contains(rootOrg.getId())) {
                        param.setContainRootOrg(true);
                        return param;
                    }
                    List<Organization> organizationList = organizationMapper.selectBatchIds(orgIds);
                    List<RightLeftIndex> indices = OrgIndexUtil.getChildrenRange(organizationList);
                    param.setIndices(indices);
                }
                return param;
            }
        }
        return null;
    }

    /**
     * 分级授权（除了报表之外的接口）
     *
     * @param companyCode
     * @param companyId
     * @param accountId
     * @param siteId
     * @return
     */
    private AuthAccountSiteModel getHQManagerModel(String companyCode, Long companyId, Long accountId, Long siteId) {
        Site site = siteMapper.selectById(siteId);
        if (null != site) {
            String siteDefaultAdmin = site.getCode() + AuthzConstant.DEFAULT_SITE_ADMIN_ROLE_CODE_SUFFIX;
            // 找出当前站点下的角色
            List<AuthzRole> roles = roleMapper.getByAccountAndSiteId(accountId, siteId);
            if (!CollectionUtils.isEmpty(roles)) {
                AuthAccountSiteModel accountSite = new AuthAccountSiteModel();
                accountSite.setUrlRanges(new HashMap<>());
                // 角色--管辖区--部门parentIdLayer
                Set<String> roleOrgParentIdLayer = null;
                // 角色--管辖区--被管理管理员id
                Set<Long> roleManagerIds = new HashSet<>();
                // 角色--模块--操作权限url
                Set<String> roleUrls = null;

                for (AuthzRole role : roles) {
                    // 如果是站点默认admin角色
                    if (siteDefaultAdmin.equalsIgnoreCase(role.getCode())) {
                        accountSite.setAccountType(AuthzConstant.ACCOUNT_TYPE_FRONT_MANAGE);
                        accountSite.setSiteAdmin(true);

                        try {
                            redisCache.hset(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_MANAGERIDS + companyCode,
                                    site.getCode() + CacheNamespace.REDIS_HASH_SEPARATOR + accountId,
                                    JSON.toJSONString(accountSite),
                                    redisManageAuthzExpired);
                        } catch (Exception e) {
                            LOGGER.error("用户权限放入redis错误：try-catch处理，不影响返回", e);
                        }

                        return accountSite;
                    }
                    // 否则是普通管理员角色
                    List<Long> roleIds = new ArrayList<>();
                    roleIds.add(role.getId());
                    roleManagerIds = authzRoleManagerMapper.getManagerAccountIdsByRoleIds(siteId, roleIds);
                    roleManagerIds.add(accountId);

                    roleUrls = operationMapper.getUrlByRoleId(role.getId());
                    if (!CollectionUtils.isEmpty(roleUrls)) {
                        for (String url : roleUrls) {
                            if (!StringUtils.isEmpty(url)) {
                                // 如果已经包含了该url
                                if (accountSite.getUrlRanges().keySet().contains(url)) {
                                    for (Long managerId : roleManagerIds) {
                                        accountSite.getUrlRanges().get(url).add(managerId);
                                    }
                                } else {
                                    accountSite.getUrlRanges().put(url, roleManagerIds);
                                }
                            }
                        }
                    }
                }
                try {
                    redisCache.hset(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_MANAGERIDS + companyCode,
                            site.getCode() + CacheNamespace.REDIS_HASH_SEPARATOR + accountId,
                            JSON.toJSONString(accountSite),
                            redisManageAuthzExpired);
                } catch (Exception e) {
                    LOGGER.error("用户权限放入redis错误：try-catch处理，不影响返回", e);
                }
                return accountSite;
            }
        }
        return null;
    }

    /**
     * 分级授权（报表的接口）
     *
     * @param companyCode
     * @param companyId
     * @param accountId
     * @param siteId
     * @return
     */
    private AuthAccountSiteModel getHQOrgModel(String companyCode, Long companyId, Long accountId, Long siteId) {
        Site site = siteMapper.selectById(siteId);
        if (null != site) {
            String siteDefaultAdmin = site.getCode() + AuthzConstant.DEFAULT_SITE_ADMIN_ROLE_CODE_SUFFIX;
            // 找出当前站点下的角色
            List<AuthzRole> roles = roleMapper.getByAccountAndSiteId(accountId, siteId);
            if (!CollectionUtils.isEmpty(roles)) {
                AuthAccountSiteModel accountSite = new AuthAccountSiteModel();
                // 角色--管辖区--部门parentIdLayer
                Set<String> roleOrgParentIdLayer = null;
                // 角色--管辖区--部门id
                Set<Long> roleOrgIds = null;
                // 角色--模块--操作权限url
                Set<String> roleUrls = null;

                for (AuthzRole role : roles) {
                    // 如果是站点默认admin角色
                    if (siteDefaultAdmin.equalsIgnoreCase(role.getCode())) {
                        accountSite.setAccountType(AuthzConstant.ACCOUNT_TYPE_FRONT_MANAGE);
                        accountSite.setSiteAdmin(true);

                        try {
                            redisCache.hset(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ORGIDS + companyCode,
                                    site.getCode() + CacheNamespace.REDIS_HASH_SEPARATOR + accountId,
                                    JSON.toJSONString(accountSite),
                                    redisManageAuthzExpired);
                        } catch (Exception e) {
                            LOGGER.error("用户权限放入redis错误：try-catch处理，不影响返回", e);
                        }

                        return accountSite;
                    }
                    // 否则是普通管理员角色
                    List<Long> roleIds = new ArrayList<>();
                    roleIds.add(role.getId());
                    roleOrgIds = organizationService.getByRoleId4IntersectionSet(roleIds, false);

                    roleUrls = operationMapper.getUrlByRoleId(role.getId());
                    if (!CollectionUtils.isEmpty(roleUrls)) {
                        accountSite.setUrlRanges(new HashMap<>());
                        for (String url : roleUrls) {
                            if (!StringUtils.isEmpty(url)) {
                                // 如果已经包含了该url
                                if (accountSite.getUrlRanges().keySet().contains(url)) {
                                    for (Long orgId : roleOrgIds) {
                                        accountSite.getUrlRanges().get(url).add(orgId);
                                    }
                                } else {
                                    accountSite.getUrlRanges().put(url, roleOrgIds);
                                }
                            }
                        }
                    }
                }
                try {
                    redisCache.hset(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ORGIDS + companyCode,
                            site.getCode() + CacheNamespace.REDIS_HASH_SEPARATOR + accountId,
                            JSON.toJSONString(accountSite),
                            redisManageAuthzExpired);
                } catch (Exception e) {
                    LOGGER.error("用户权限放入redis错误：try-catch处理，不影响返回", e);
                }
                return accountSite;
            }
        }
        return null;
    }

    private List<CommonTree> buildTree(List<AuthzMenu> authzMenus) {
        Set<Long> menuIds = new HashSet<>();
        for (AuthzMenu authzMenu : authzMenus) {
            menuIds.add(authzMenu.getId());
        }
        if (!CollectionUtils.isEmpty(menuIds)) {
            List<AuthzMenu> menus = authzMenuMapper.selectBatchIds(menuIds);
            if (!CollectionUtils.isEmpty(menus)) {
                for (AuthzMenu menu : menus) {
                    String parentIdLayer = menu.getParentIdLayer();
                    if (!StringUtils.isEmpty(parentIdLayer)) {
                        String[] ids = parentIdLayer.split("_");
                        if (ids.length > 0) {
                            for (String id : ids) {
                                menuIds.add(Long.valueOf(id));
                            }
                        }
                    }
                }
            }

            List<AuthzMenu> realMenus = authzMenuMapper.selectBatchIds(menuIds);
            Set<Long> menuIdss = new HashSet<>();
            for (AuthzMenu a:realMenus
            ) {
                if (a.getEnabled()==0||a.getDeleted()==1){
                    menuIdss.add(a.getId());
                }
            }
            List<CommonTree> menuTrees = new ArrayList<>();
            for (AuthzMenu m : realMenus) {
                //自己被禁用或者父类菜单被禁用的菜单不出现在树中
                if (menuIdss.contains(m.getId()) || menuIdss.contains(m.getParentId())){
                    continue;
                }
                CommonTree tree = new CommonTree();
                tree.setNode(m);
                tree.setPId(m.getParentId());
                tree.setId(m.getId());
                tree.setName(m.getName());
                tree.setSort(m.getSort());
                menuTrees.add(tree);
            }
            menuTrees = TreeUtil.buildTree(menuTrees, 0L);
            return menuTrees;
        }
        return new ArrayList<>();
    }

    /**
     * 获取企业下根部门
     *
     * @param companyId
     * @return
     */
    private Organization getRootOrg(long companyId) {
        Organization rootOrg = new Organization();
        rootOrg.setCompanyId(companyId);
        rootOrg.setDeleted(false);
        rootOrg.setParentId(0L);
        rootOrg = rootOrg.selectOne(new EntityWrapper(rootOrg));
        return rootOrg;
    }
    
    @Override
    public OrgAccountVo getOrgAndUserOfAdmin(Long accountId, Long siteId) {
    	// 根据登陆人和站点 获取关联的角色
    	List<AuthzRole> roles = roleMapper.getByAccountAndSiteId(accountId, siteId);
    	List<Long> roleIds = roles.stream().map(AuthzRole::getId).collect(Collectors.toList());
    	
    	if(null == roleIds || roleIds.isEmpty()) {
    		LOGGER.warn("User {} don't have roles.", accountId);
    		return null;
    	}
    	
    	// 根据角色 获取关联的部门及子部门
    	Set<Long> roleOrgIds = organizationService.getByRoleId4IntersectionSet(roleIds, true);
    	List<Long> orgs = new ArrayList<Long>(roleOrgIds);
    	
    	// 根据角色 获取关联的用户
    	List<AccountOrgVo> users = organizationMapper.getUserByRoleId(roleIds);
    	
    	return OrgAccountVo.builder().orgs(orgs).users(users).build() ;
    }

    @Override
    public Integer getOverlapUserCount(OrgAccountVo adminManageUserInfo, List<Long> serviceVisibleOrgIds, List<Long> serviceVisibleUserIds, Long siteId, Long companyId) {

        // 管辖区
        List<Long> manageOrgIds = adminManageUserInfo.getOrgs();
        List<AccountOrgVo> manageUsers = adminManageUserInfo.getUsers();
        List<Long> manageIds = manageUsers.stream().map(AccountOrgVo::getAccountId).collect(Collectors.toList());

        // 可见范围
        List<Long> visibleOrgIds = getAllOrgIds(serviceVisibleOrgIds, companyId);

        if (manageIds == null) {
            manageIds = new ArrayList<>();
        }
        if (manageIds == null) {
            manageIds = new ArrayList<>();
        }
        if (serviceVisibleUserIds == null) {
            serviceVisibleUserIds = new ArrayList<>();
        }


//        // 管辖区为部门 且 可见范围为部门
//        if ((manageUsers == null || manageUsers.isEmpty()) && (serviceVisibleUserIds == null || serviceVisibleUserIds.isEmpty())) {
//
//            return iAccountService.getUserCount(manageOrgIds,companyId);
//        }

//        // 管辖区为指定用户 且 可见范围为指定用户
//        if((visibleOrgIds == null || visibleOrgIds.isEmpty()) && (manageOrgIds == null|| manageOrgIds.isEmpty())) {
//            manageIds.retainAll(serviceVisibleUserIds);
//            return manageIds.size();
//        }


        manageOrgIds.retainAll(visibleOrgIds);

        List<AccountVO> visibleAndManageUser = new ArrayList<AccountVO>();
        List<AccountVO> users = iAccountService.idsGet(serviceVisibleUserIds);
        for (AccountVO user : users) {
            // 在管辖区内
            if (manageOrgIds.contains(user.getOrgId()) || manageIds.contains(user.getId())) {
                // 不在可见范围的部门中
                if (!visibleOrgIds.contains(user.getOrgId())) {
                    visibleAndManageUser.add(user);
                }
            }
        }
        return iAccountService.getUserCount(manageOrgIds, companyId) + visibleAndManageUser.size();
    }

    /**
     * 获取部门下面的字部门
     *
     * @param orgIds
     * @param companyId
     * @return
     */
    private List<Long> getAllOrgIds(List<Long> orgIds, Long companyId) {
        List<Long> allordIds = new ArrayList<Long>();
        if (orgIds == null || orgIds.isEmpty()) {
            return allordIds;
        }
        for (Long orgId : orgIds) {
            allordIds.addAll(authorityService.getChildOrgIds(orgId, companyId));
        }
        return allordIds;
    }

    @Override
    public List<AuthzRole> getByAccountId(Long accountId) {
        return roleMapper.getByAccountId(accountId);
    }
}
