package com.yizhi.system.application.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.yizhi.system.application.service.AuthorityService;
import com.yizhi.system.application.tree.TreeBuilder;
import com.yizhi.system.application.tree.TreeBuilderFactory;
import com.yizhi.system.application.vo.Tree;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.AuthzGroupMember;
import com.yizhi.system.application.domain.AuthzUserGroup;
import com.yizhi.system.application.domain.Organization;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.enums.MemberType;
import com.yizhi.system.application.mapper.AccountMapper;
import com.yizhi.system.application.mapper.CompanyMapper;
import com.yizhi.system.application.mapper.AuthzGroupMemberMapper;
import com.yizhi.system.application.mapper.OrganizationMapper;
import com.yizhi.system.application.mapper.AuthzUserGroupMapper;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.util.application.json.JsonUtil;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/20 15:43
 */
@Service
@Transactional
public class AuthorityServiceImpl implements AuthorityService {
	private static final Logger logger = LoggerFactory.getLogger(AuthorityServiceImpl.class);

    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private AccountMapper accountMapper;
    @Autowired
    RedisCache redisCache;
    @Autowired
    private AuthzGroupMemberMapper memberMapper;
    @Autowired
    private AuthzUserGroupMapper groupMapper;
    @Autowired
    private CompanyMapper companyMapper;
    
//	@PostConstruct
	public void init(){
		List<Long> companyIds=companyMapper.getAllCompanyIds();
		if(CollectionUtils.isNotEmpty(companyIds)){
			for(Long companyId:companyIds){
				buildLayerOrgIds(companyId);
			}
		}
	}

    /**
     * 组装部门id层级结构（当前companId下所有的）
     *
     * @param companyId
     * @return
     */
    @Override
    public List<Tree> buildLayerOrgIds(Long companyId) {
        Organization example = new Organization();
        example.setCompanyId(companyId);
        example.setDeleted(false);

        List<Organization> list = organizationMapper.selectList(new EntityWrapper<Organization>(example));
        List<Tree> trees = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            for (Organization o : list) {
                Tree tree = new Tree();
                tree.setKey(o.getId());
                tree.setParentId(o.getParentId());
                tree.setCode(o.getCode());
                tree.setTitle(o.getName());
                trees.add(tree);
            }
            TreeBuilder treeBuilder = TreeBuilderFactory.getInstance();
            List<Tree> treeList = treeBuilder.treeList(trees);
            String str = JsonUtil.list2Json(treeList);
            // 放入redis中
//            RedisConnection redisConnection = null;
//            try {
//            	redisConnection = redisConnectionFactory.getConnection();
//                redisConnection.hSet(SafeEncoder.encode(AuthzConstant.REDIS_COMPANY_STRUCTURE), SafeEncoder.encode(companyId + ""), SafeEncoder.encode(str));
//			} catch (Exception e) {
//				logger.error("",e);
//			} finally{
//				redisConnection.close();
//			}
            return treeList;
        }
        return null;
    }

    /**
     * 从 redis 中获取组织结构
     *
     * @param companyId
     * @return
     */
//    private List<Tree> getLayerOrgIdsFromRedis(Long companyId) {
//        RedisConnection redisConnection = null;
//        List<Tree> list = null;
//        try {
//        	redisConnection = redisConnectionFactory.getConnection();
//            byte[] bytes = redisConnection.hGet(SafeEncoder.encode(AuthzConstant.REDIS_COMPANY_STRUCTURE), SafeEncoder.encode(companyId + ""));
//            if (bytes != null) {
//                list = JsonUtil.json2List(SafeEncoder.encode(bytes), Tree.class);
//            }
//		} catch (Exception e) {
//			logger.error("",e);
//		} finally{
//			redisConnection.close();
//		}
//        return list;
//    }

	@Override
	public List<Tree> getAllOrgTree(Long companyId) {
		 // 从redis中查出企业部门结构
//        List<Tree> orgTree = getLayerOrgIdsFromRedis(companyId);
        List<Tree> orgTree = new ArrayList<>();
        if (CollectionUtils.isEmpty(orgTree)) {
            orgTree = buildLayerOrgIds(companyId);
        }
        return orgTree;
	}

	@Override
	public Tree getOrgTree(Long orgId, Long companyId) {
		List<Tree> treeAll=getAllOrgTree(companyId);
		TreeBuilder treeBuilder = TreeBuilderFactory.getInstance();
		Tree tree=treeBuilder.getChildList(treeAll, orgId);	
		return tree;
	}
	
	@Override
	public List<Long> getChildOrgIds(Long orgId, Long companyId) {
		TreeBuilder treeBuilder = TreeBuilderFactory.getInstance();
		Tree tree=getOrgTree(orgId,companyId);	
		return treeBuilder.getChildIds(null,tree);
	}

	@Override
	public List<Long> getAuthOrgAndGroup(Long accountId, Long siteId) {
		List<Long> ids=new ArrayList<>();
		ids.add(accountId);
		//查询用户信息
		Account account=accountMapper.selectById(accountId);
		//查询用户所在部门的所有子部门
		List<Tree> treeAll=getAllOrgTree(account.getCompanyId());
		TreeBuilder treeBuilder = TreeBuilderFactory.getInstance();	
		ids.addAll(treeBuilder.getChiefIds(treeAll,account.getOrgId(),null));
		//查询用户所在部门的所有上级部门
		List<Long> chiefIds=treeBuilder.getChiefIds(treeAll, account.getOrgId(),null);
		//查询站点下创建的用户组
		AuthzUserGroup condition=new AuthzUserGroup();
		condition.setSiteId(siteId);
		condition.setDeleted(false);
		List<AuthzUserGroup> groups=groupMapper.selectList(QueryUtil.condition(condition));
		/*
		 * 判断用户组中是否包含用户规则：
		 * 1,当groupMember type字段是2（用户）时，循环对比accountId和groupMember的memberId，值相等时表示用户组包含用户，退出循环
		 * 2,当groupMember type字段是1（部门）时，根据groupMember的memberId查询其下属部门id，如果accountId的所有上级部门包含在里面，表示用户组包含用户，退出循环
		 */
		if(CollectionUtils.isNotEmpty(groups)){
			boolean flag = false;
			for(AuthzUserGroup group:groups){
				AuthzGroupMember wrapper=new AuthzGroupMember();
				wrapper.setGroupId(group.getId());
				wrapper.setDeleted(0);
				List<AuthzGroupMember> members=memberMapper.selectList(QueryUtil.condition(wrapper));
				if(CollectionUtils.isNotEmpty(members)){
					for(AuthzGroupMember member:members){
						//判断规则1条件
						if(MemberType.USER.getCode().intValue()==member.getType().intValue()
								&&accountId.longValue()==member.getMemberId().longValue()){
							flag=true;
							break;
						}
						//判断规则2条件
						if(MemberType.ORG.getCode().intValue()==member.getType().intValue()){
							Tree tree1=treeBuilder.getChildList(treeAll, member.getMemberId());
							List<Long> childOrgIds=treeBuilder.getChildIds(null,tree1);
							if(CollectionUtils.isNotEmpty(chiefIds)&&CollectionUtils.isNotEmpty(childOrgIds)){
								for(Long id:chiefIds){
									if(childOrgIds.contains(id)){
										flag=true;
										break;
									}
								}
							}
						}
					}
				}
				if(flag){
					ids.add(group.getId());
				}
			}
		}
		Collections.sort(ids);
		return ids;
	}

	@Override
	public List<Long> getChiefOrgIds(Long orgId, Long companyId) {
		TreeBuilder treeBuilder = TreeBuilderFactory.getInstance();
		List<Tree> treeAll=getAllOrgTree(companyId);
		return treeBuilder.getChiefIds(treeAll, orgId, null);
	}

}
