package com.yizhi.system.application.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.system.application.domain.AuthzAccountRole;
import com.yizhi.system.application.domain.AuthzRoleMenu;
import com.yizhi.system.application.mapper.AuthzAccountRoleMapper;
import com.yizhi.system.application.service.IAuthzAccountRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 角色和角色 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-05-15
 */
@Service
public class AuthzAccountRoleServiceImpl extends ServiceImpl<AuthzAccountRoleMapper, AuthzAccountRole> implements IAuthzAccountRoleService {


	@Autowired
	private AuthzAccountRoleMapper authzAccountRoleMapper;


	@Override
	public List<AuthzAccountRole> getAllAdmin() {
		// TODO Auto-generated method stub
		return authzAccountRoleMapper.getAllAdmin();
	}

    @Override
    public List<AuthzRoleMenu> selectMenuListByAccountId(Long accountId, Long menuId) {
        return authzAccountRoleMapper.selectMenuListByAccountId(accountId,menuId);
    }

    @Override
    public List<Long> getAdminIdsByAccountId(Long companyId,Long siteId,Long accountId) {
        return authzAccountRoleMapper.getAdminIdsByAccountId(companyId,siteId,accountId);
    }

    /**
     * 根据用户ID查询关联角色ID集合
     * @param accountIds
     * @return
     */
    @Override
    public List<AuthzAccountRole> getRoleIdsByAccountIds(List<Long> accountIds) {
        return authzAccountRoleMapper.getRoleIdsByAccountIds(accountIds);
    }
}
