package com.yizhi.system.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.constant.SecurityError;
import com.yizhi.system.application.domain.*;
import com.yizhi.system.application.enums.OrderField;
import com.yizhi.system.application.mapper.*;
import com.yizhi.system.application.service.IAuthzRoleService;
import com.yizhi.system.application.service.ICompanyService;
import com.yizhi.system.application.service.ISiteService;
import com.yizhi.system.application.vo.CompanyVO;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.encrypt.ShaEncrypt;
import com.yizhi.util.application.json.JsonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 企业管理 服务实现类
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
@Service
@Transactional
public class CompanyServiceImpl extends ServiceImpl<CompanyMapper, Company> implements ICompanyService {

    private static final Logger logger = LoggerFactory.getLogger(CompanyServiceImpl.class);

    @Value("${redis.manage.authz.expired}")
    private Long redisManageAuthzExpired;

    @Autowired
    IdGenerator idGenerator;
    @Autowired
    AccountMapper accountMapper;
    @Autowired
    CompanyMapper companyMapper;
    @Autowired
    CompanyContactorMapper companyContactorMapper;
    @Autowired
    SiteMapper siteMapper;
    @Autowired
    RedisCache redisCache;
    @Autowired
    AuthzRoleMapper roleMapper;
    @Autowired
    AuthzAccountRoleMapper accountRoleMapper;
    @Autowired
    OrganizationMapper orgMapper;
    @Autowired
    IAuthzRoleService roleService;
    @Autowired
    OrganizationMapper organizationMapper;
    @Autowired
    ISiteService siteService;

//    @PostConstruct
//    public void inint() {
//        //if(!redisCache.exists(CacheNamespace.REDIS_COMPANY_IDS)){
//        List<Company> queryList = this.selectList(QueryUtil.condition(new Company()));
//        for (Company item : queryList) {
//            CompanyVO companyVO = new CompanyVO();
//            BeanUtils.copyProperties(item, companyVO);
//            redisCache.hset(CacheNamespace.REDIS_COMPANY_IDS, item.getCode().toString(), JsonUtil.object2Json(companyVO));
//        }
//        //}
//    }


    @Override
    public List<Company> findAllCompany() {
        EntityWrapper<Company> company = QueryUtil.condition(new Company());
        company.eq("status",2);
        return this.baseMapper.selectList(company);
    }

    /**
     * 查找公司信息列表
     */
    @Override
    public Page<Company> list(Company company, Page<Company> page) {
        logger.info("查询账号列表条件：{}", company);
        page.setAsc(false);
        page.setOrderByField(OrderField.CREATETIME.getCode());
        EntityWrapper<Company> where = QueryUtil.condition(new Company());
        int status = 2;
        if (company.getStatus() != null) {
            status = company.getStatus();
            where.where("status={0}", status);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(company.getName())) {
            where.and().like("name", company.getName(), SqlLike.DEFAULT);
        }
        return this.selectPage(page, where);
    }

    /**
     * 更改服务到期时间
     */
    @Override
    public Boolean updateEndTime(Company company) {
        if (updateById(company)) {
            return true;
        } else {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    /**
     * 更改公司状态
     */
    @Override
    public Boolean updateState(Long id, Integer status) {
        Company company = new Company();
        company.setId(id);
        company.setStatus(status);
        logger.info("***************************************************更新企业信息开始**********************************************");
        if (this.updateById(company)) {
            logger.info("***************************************************更新企业信息成功**********************************************");
            return true;
        } else {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    /**
     * 更改企业名字
     */
    @Override
    public Boolean updateCompanyName(Long id, String companyName) {
        Company company = new Company();
        company.setId(id);
        company.setName(companyName);
        if (updateById(company)) {
            return true;
        } else {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    @Override
    public Boolean updateContact(CompanyContactor contactor) {
        EntityWrapper<CompanyContactor> ew = QueryUtil.condition(new CompanyContactor());
        ew.eq("company_id",contactor.getCompanyId()).eq("telephone",contactor.getTelephone())
                .ne("id",contactor.getId());
        int extisNum = companyContactorMapper.selectCount(ew);
        if(extisNum>0){
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), "联系人电话号码已经存在，保存失败");
        }
        if (companyContactorMapper.updateById(contactor) > 0) {
            return true;
        } else {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    /**
     * 获取公司信息
     */
    @Override
    public Company get(Long id) {
        //1.获取公司信息
        Company company = companyMapper.selectById(id);

        //2.获取公司联系人
        CompanyContactor contactor = new CompanyContactor();
        contactor.setCompanyId(id);
        contactor.setDeleted(false);
        company.setContactors(companyContactorMapper.selectList(QueryUtil.condition(contactor)));

        //4.设置关闭账号的人数
        company.setMemberCloseCount(accountMapper.getCloseCountByCompanyId(id));

        //5.总账号人数
        company.setMemberCount(accountMapper.getCountByCompanyId(id));

        //6.公司部门数
        company.setOrgCount(organizationMapper.getCountByCompanyId(id));
        return company;
    }

    /**
     * 查找公司封装vo
     *
     * @param id
     * @return
     */
    @Override
    public Page<Company> getPage(Long id, Integer pageNo, Integer pageSize) {
        Page<Company> retData = new Page<>();
        //1.获取公司信息
        Company company = companyMapper.selectById(id);

        //2.获取公司联系人
        CompanyContactor contactor = new CompanyContactor();
        contactor.setCompanyId(id);
        contactor.setDeleted(false);
        Page<CompanyContactor> page = new Page<>(pageNo, pageSize);
        List<CompanyContactor> data = companyContactorMapper.selectPage(page, QueryUtil.condition(contactor));
        BeanUtils.copyProperties(page, retData ,"records");
        company.setContactors(data);

        //4.设置关闭账号的人数
        company.setMemberCloseCount(accountMapper.getCloseCountByCompanyId(id));

        //5.总账号人数
        company.setMemberCount(accountMapper.getCountByCompanyId(id));

        //6.公司部门数
        company.setOrgCount(organizationMapper.getCountByCompanyId(id));
        // 设置返回数据
        retData.setRecords(Arrays.asList(company));
        return retData;
    }

    /**
     * 保存公司信息
     */
    @Override
    public Boolean insertDetail(Company company) {
        if (StringUtils.isEmpty(company.getCode())) {
            throw new BizException("4001", "code填写错误，正确形式：{企业code}/{默认站点code}");
        }
        String domain = company.getCode();
        String[] codes = domain.split("/");
        if (codes.length < 2) {
            throw new BizException("4001", "code填写错误，正确形式：{企业code}/{默认站点code}");
        }
        Long companyId = idGenerator.generate();
        company.setCode(codes[0]);
        company.setId(companyId);
        company.setStatus(2);  //初始状态是2
        //1检查企业code和name不能和数据库已有数据重复
        Company existCode = new Company();
        existCode.setCode(company.getCode());
        int countCodeNum = companyMapper.selectCount(QueryUtil.condition(existCode));
        if (countCodeNum > 0) {
            throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(), "公司编码已存在");
        }
        Company existName = new Company();
        existName.setName(company.getName());
        int countNameNum = companyMapper.selectCount(QueryUtil.condition(existName));
        if (countNameNum > 0) {
            throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(), "公司名称已存在");
        }
        /*if (companyMapper.countExistCode(0L, company.getCode()) > 0) {
            throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(), "公司编码已存在");
        }
        if (companyMapper.countExistName(0L, company.getName()) > 0) {
            throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(), "公司名称已存在");
        }*/
        company.setDomain(domain);
        //2新增企业
        if (!insert(company)) {
            throw new BizException(ReturnCode.SAVE_FAIL.getCode(), ReturnCode.SAVE_FAIL.getMsg());
        }
        //3设置根组织
        Organization org = new Organization();
        Long orgId = idGenerator.generate();
        org.setId(orgId);
        org.setCode(codes[0] + AuthzConstant.DEFAULT_COMPANY_ORG_ROOT_CODE_SUFFIX);
        org.setCompanyId(companyId);
        org.setName(company.getName());
        org.setParentIdLayer(String.valueOf(orgId));
        org.setLeftIndex(1);
        org.setRightIndex(2);
        if (orgMapper.insert(org) < 1) {
            throw new BizException(SecurityError.SETUP_ORG_ERROR, SecurityError.SETUP_ORG_ERROR_MSG);
        }
        //4设置联系人
        List<CompanyContactor> contactors = company.getContactors();
        if (CollectionUtils.isNotEmpty(contactors)) {
            for (CompanyContactor contactor : contactors) {
                contactor.setId(idGenerator.generate());
                contactor.setCompanyId(companyId);
                if (companyContactorMapper.insert(contactor) < 1) {
                    throw new BizException(SecurityError.SETUP_CONTACTOR_ERROR, SecurityError.SETUP_CONTACTOR_ERROR_MSG);
                }
            }
        }
        //5设置默认站点
        Site site = new Site();
        Long siteId = idGenerator.generate();
        site.setId(siteId);
        site.setCode(codes[1]);
        site.setCompanyId(companyId);
        site.setDomain(domain);
        site.setLogo(company.getLogo());
        site.setName(company.getName());
        site.setType(AuthzConstant.SITE_TYPE_DEFAULT);
        site.setUserGroupId(0L);
        site.setLoginCode(siteService.getLoginCode());
        if (siteMapper.insert(site) < 1) {
            throw new BizException(SecurityError.SETUP_SITE_ERROR, SecurityError.SETUP_SITE_ERROR_MSG);
        }
        site.setHasDeal(true);
        siteMapper.updateById(site);
        //6添加企业默认角色
        // 6.1 添加默认站点的站点管理员角色
        AuthzRole siteAdminRole = new AuthzRole();
        siteAdminRole.setId(idGenerator.generate());
        siteAdminRole.setEnabled(1);
        siteAdminRole.setCode(site.getCode() + AuthzConstant.DEFAULT_SITE_ADMIN_ROLE_CODE_SUFFIX);
        siteAdminRole.setSiteId(siteId);
        siteAdminRole.setDescription(site.getName() + "默认站点管理员");
        siteAdminRole.setCompanyId(companyId);
        siteAdminRole.setName(siteAdminRole.getDescription());
        if (roleMapper.insert(siteAdminRole) < 1) {
            throw new BizException(SecurityError.SETUP_SITE_ERROR, SecurityError.SETUP_ROLE_ERROR_MSG);
        }
        // TODO 6.2 是否需要默认功能角色
//		Role condition=new Role();
//		Long adminId=0L;
//		condition.setCompanyId(0L);
//		List<Role> roles=roleMapper.selectList(QueryUtil.condition(condition));
//		if(CollectionUtils.isNotEmpty(roles)){
//			for(Role role:roles){
//				Long roleId=idGenerator.generate();
//				if(role.getCode().equals(BuiltInRole.SUPER.getCode())){
//					adminId=roleId;
//				}
//				role.setId(roleId);
//				role.setCompanyId(companyId);
//			}
//			if(!roleService.insertBatch(roles)){
//				throw new BizException(SecurityError.SETUP_ROLE_ERROR,SecurityError.SETUP_ROLE_ERROR_MSG);
//			}
//		}
        //7设置管理员
        Account account = company.getSuperAdmin();
        Long accountId = idGenerator.generate();
        account.setId(accountId);
        account.setCompanyId(companyId);
        account.setOrgId(orgId);
        account.setFullName(account.getName());
        account.setCompanyDefaultAdmin(1);
        account.setPassword(ShaEncrypt.encryptNewPassword(account.getPassword()));
        if (accountMapper.insert(account) < 1) {
            throw new BizException(SecurityError.SETUP_SUPER_ADMIN_ERROR, SecurityError.SETUP_SUPER_ADMIN_ERROR_MSG);
        }
        //8将管理员角色赋予管理员
        AuthzAccountRole accountRole = new AuthzAccountRole();
        accountRole.setId(idGenerator.generate());
        accountRole.setSiteId(siteId);
        accountRole.setAccountId(accountId);
        accountRole.setRoleId(siteAdminRole.getId());
        if (accountRoleMapper.insert(accountRole) < 1) {
            throw new BizException(SecurityError.SETUP_ROLE_ERROR, SecurityError.SETUP_ROLE_ERROR_MSG);
        }
        try {
            company = company.selectById();
            CompanyVO companyVO = new CompanyVO();
            BeanUtils.copyProperties(company, companyVO);
            redisCache.hset(CacheNamespace.REDIS_COMPANIES, company.getCode(),
                    JsonUtil.getJSONString(companyVO), redisManageAuthzExpired);
        } catch (Exception e) {
            logger.debug("新增企业放入redis错误：try-catch处理，不影响返回", e);
        }
        return true;
    }

    @Override
    public Boolean update(Company company) {
        // code不可以更改
        company.setCode(null);
        //如果修改name,检查name是否重复
        if (StringUtils.isNotEmpty(company.getName())) {
            if (companyMapper.countExistName(company.getId(), company.getName()) > 0) {
                throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(), "公司名称已存在");
            }
        }
        if (this.updateById(company)) {
            Account account = company.getSuperAdmin();
            if(account != null){
                Account accountOld = accountMapper.selectById(account.getId());
                if(accountOld == null){
                    throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), "超级管理账号不存在！");
                }
                if (StringUtils.isNotBlank(account.getName())) {
                    Account accountWhere = new Account();
                    accountWhere.setName(account.getName());
                    accountWhere.setCompanyId(company.getId());
                    int oldCount = accountMapper.selectCount(QueryUtil.condition(accountWhere));
                    if (oldCount > 0) {
                        throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), "超级管理登陆账号已存在,不能修改");
                    }
                }
                if (account != null) {
                    logger.info("************************************************************获取用户信息={}************************************", JSON.toJSONString(account));
                    String pwd = account.getPassword();
                    if (StringUtils.isNotBlank(pwd)) {
                        account.setPassword(ShaEncrypt.encryptNewPassword(pwd));
                    }
                    accountMapper.updateById(account);
                }
                try {
                    company = company.selectById();
                    CompanyVO companyVO = new CompanyVO();
                    BeanUtils.copyProperties(company, companyVO);
                    redisCache.hset(CacheNamespace.REDIS_COMPANIES, company.getCode(),
                            JsonUtil.getJSONString(companyVO), redisManageAuthzExpired);
                } catch (Exception e) {
                    logger.debug("新增企业放入redis错误：try-catch处理，不影响返回", e.getLocalizedMessage());
                }
            }
            return true;
        } else {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    @Override
    public void deleteContact(CompanyContactor contactor) {
        contactor.setDeleted(true);
        if (companyContactorMapper.updateById(contactor) < 1) {
            throw new BizException(ReturnCode.UPDATE_FAIL.getCode(), ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    @Override
    public void insertContact(CompanyContactor contactor) {

        CompanyContactor account = new CompanyContactor();
        account.setCompanyId(contactor.getCompanyId());
        account.setTelephone(contactor.getTelephone());
        account.setDeleted(false);
        int extisNum = companyContactorMapper.selectCount(QueryUtil.condition(account));
        if(extisNum>0){
            throw new BizException(ReturnCode.SAVE_FAIL.getCode(), "联系人电话号码已经存在，保存失败");
        }
        contactor.setId(idGenerator.generate());
        if (companyContactorMapper.insert(contactor) < 1) {
            throw new BizException(ReturnCode.SAVE_FAIL.getCode(), ReturnCode.SAVE_FAIL.getMsg());
        }
    }

	@Override
	public CompanyVO findByAuthCode(String authcode) {
		return companyMapper.findByAuthCode(authcode);
	}
}
