package com.yizhi.system.application.service.impl;

import java.util.*;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.enums.SqlLike;
import com.google.common.collect.Lists;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.system.application.domain.Dictionary;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.system.application.mapper.DictionaryMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.system.application.service.DictionaryService;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-01-04
 */
@Service
@Transactional
@Slf4j
public class DictionaryServiceImpl extends ServiceImpl<DictionaryMapper, Dictionary> implements DictionaryService {

    @Autowired
    private IdGenerator idGenerator;


    @Override
    public boolean insertDetail(Dictionary dictionary) {
        Dictionary dictExample = new Dictionary();
        dictExample.setCode(dictionary.getCode());
        dictExample.setEnabled(Boolean.TRUE);

        int num = baseMapper.selectCount(new EntityWrapper<Dictionary>(dictExample));
        if (num > 0) {
            throw new RuntimeException("Code has alredy existed! -- code: " + dictionary.getCode());
        }

        // 设置id、设置默认可用
        dictionary.setId(idGenerator.generate());
        dictionary.setEnabled(Boolean.TRUE);

        // 设置layer、rootId、parentId
        if (null == dictionary.getParentId() || dictionary.getParentId() == 0) {
            dictionary.setLayer(0);
            dictionary.setRootId(new Long(0));
            dictionary.setParentId(new Long(0));
        } else {
            Dictionary dictForParent = new Dictionary();
            dictForParent.setId(dictionary.getParentId());
            dictForParent.setEnabled(Boolean.TRUE);
            Dictionary parent = baseMapper.selectOne(dictForParent);

            dictionary.setLayer(parent.getLayer() + 1);
            if (parent.getParentId() == 0) { // 若父对象的parentId为0，则父为root
                dictionary.setRootId(parent.getId());
            } else { // 父对象parentId不为0，则父为非root，父rootId有真实值
                dictionary.setRootId(parent.getRootId());
            }
        }

        // 设置排序
        if (null == dictionary.getSort()) {
            Dictionary layerDict = new Dictionary();
            layerDict.setLayer(dictionary.getLayer());
            layerDict.setRootId(dictionary.getRootId());
            layerDict.setEnabled(Boolean.TRUE);

            int layerCount = baseMapper.selectCount(new EntityWrapper<Dictionary>(layerDict));
            dictionary.setSort(layerCount + 1);
        }

        return baseMapper.insert(dictionary) == 1;
    }

    @Override
    public Dictionary findByCode(String code) {
        Dictionary dictExample = new Dictionary();
        dictExample.setCode(code);
        dictExample.setEnabled(Boolean.TRUE);

        return baseMapper.selectOne(dictExample);
    }

    @Override
    public List<Dictionary> listRootDictionary() {
        Dictionary dictionary = new Dictionary();
        dictionary.setRootId(new Long(0));
        dictionary.setEnabled(Boolean.TRUE);
        return baseMapper.selectList(new EntityWrapper<Dictionary>(dictionary));
    }

    @Override
    public Page<Dictionary> listByPage(Long parentId, String code, String cnName, String enName, int pageNo, int pageSize, String pageSortFiled, String pageSortType) {
        // 组装page，页数、条数、排序字段、排序方式
        Page<Dictionary> page = new Page<Dictionary>(pageNo, pageSize);
        page.setOrderByField(pageSortFiled);
        page.setAsc((null == pageSortType || "desc".equals(pageSortType)) ? false : true);

        Dictionary dictionary = new Dictionary();
        dictionary.setParentId(parentId);
        dictionary.setCode(code);
        dictionary.setEnabled(Boolean.TRUE);
        EntityWrapper<Dictionary> ew = new EntityWrapper<>(dictionary);
        if (StringUtils.isNotEmpty(cnName)) {
            ew.like("cn_name", cnName);
        }
        if (StringUtils.isNotEmpty(enName)) {
            ew.like("en_name", enName);
        }

        return this.selectPage(page, ew);
    }

    @Override
    public List<Dictionary> listChildren(long id, Boolean includeParent, Integer layer) {
        String idsStr = baseMapper.getDictChildList(id, includeParent, layer, true);
        if (StringUtils.isNotEmpty(idsStr)) {
            String[] ids = idsStr.split(",");
            List<Long> idList = new ArrayList<Long>();
            for (String item : ids) {
                idList.add(new Long(item));
            }
            if(includeParent){
                idList.add(id);
            }
            return this.selectBatchIds(idList);
        }
        return new ArrayList<Dictionary>();
    }

    @Override
    public boolean batchDelete(Long[] ids) {
        // 待删除id
        StringBuilder idsToDeleteSb = new StringBuilder();
        for (int i = 0; i < ids.length; i++) {
            idsToDeleteSb.append("," + baseMapper.getDictChildList(ids[i], true, null, true));
            idsToDeleteSb.append("," +ids[i]);
        }
        String[] idsToDeleteStr = idsToDeleteSb.toString().split(",");

        // 去重
        Set<String> idSet = new HashSet<String>();
        for (String id : idsToDeleteStr) {
            if (StringUtils.isNotEmpty(id)) {
                idSet.add(id);
            }
        }

        List<Dictionary> dictToDelete = new ArrayList<>();
        for (String id : idSet) {
            if (StringUtils.isEmpty(id)) {
                continue;
            }
            Dictionary dictionary = new Dictionary();
            dictionary.setId(new Long(id));
            dictionary.setEnabled(Boolean.FALSE);
            dictToDelete.add(dictionary);
        }
        return this.updateBatchById(dictToDelete);
    }

    @Override
    public boolean chedkHasChild(Long id) {
        Dictionary dictExample = new Dictionary();
        dictExample.setParentId(id);
        dictExample.setEnabled(Boolean.TRUE);

        int num = this.selectCount(new EntityWrapper<Dictionary>(dictExample));
        return num > 0;
    }

    @Override
    public boolean checkCode(String code) {
        Dictionary dictExample = new Dictionary();
        dictExample.setCode(code);
        dictExample.setEnabled(Boolean.TRUE);

        int num = this.selectCount(new EntityWrapper<Dictionary>(dictExample));
        return num > 0;
    }

    @Override
    public boolean insertBySearchName(String searchName) {

        try {
            if(ObjectUtils.isNotEmpty(searchName)) {
                Dictionary search = findByCode("all_search_list");
                if (search != null) {
                    List<Dictionary> DictionaryList = listChildren(search.getId(), false, 1);
                    Optional<Dictionary> optional =null;
                    if(DictionaryList==null){
                        DictionaryList = Lists.newArrayList();
                    }else {
                        optional = DictionaryList.stream().filter(d -> Objects.equals(d.getCnName(), searchName)).findFirst();
                    }
                    Date today = new Date();
                    Dictionary dictionary = new Dictionary();
                    dictionary.setUpdateById(ContextHolder.get().getAccountId());
                    dictionary.setUpdateByName(ContextHolder.get().getAccountName());
                    dictionary.setUpdateTime(today);
                    String key ="search_list"+"_"+searchName+"_"+ContextHolder.get().getAccountId();
                    if(optional!=null&&optional.isPresent()){
                        Dictionary dictionaryCount = findByCode("all_search_count");
                        int maxCount = 3;
                        if(dictionaryCount!=null){
                            maxCount = Integer.valueOf(dictionaryCount.getValue());
                        }
                        dictionary = optional.get();
                        if(Objects.equals(dictionary.getLayer(),Integer.valueOf(1))){
                            return true;
                        }
                        Dictionary dictionarySub = findByCode(key);
                        if(dictionarySub==null){
                            dictionarySub = new Dictionary();
                            BeanUtil.copyProperties(dictionary,dictionarySub);
                            dictionarySub.setParentId(dictionary.getId());
                            dictionarySub.setCnName(searchName);
                            dictionarySub.setCode(key);
                            dictionarySub.setEnName(key);
                            insertDetail(dictionarySub);
                        }
                        int valueCount = listChildren(dictionary.getId(), false, 3).size();
                        if(valueCount>maxCount){
                            dictionary.setLayer(1);
                        }
                        dictionary.setValue(valueCount+"");
                        updateById(dictionary);
                    }else{
                        dictionary.setCnName(searchName);
                        dictionary.setCode("all_search_list_"+searchName);
                        dictionary.setEnName("all_search_list_"+searchName);
                        dictionary.setValue("1");
                        dictionary.setCreateById(ContextHolder.get().getAccountId());
                        dictionary.setCreateByName(ContextHolder.get().getAccountName());
                        dictionary.setCreateTime(today);
                        dictionary.setSystemFlag(1);
                        dictionary.setSort(DictionaryList.size());
                        dictionary.setParentId(search.getId());
                        insertDetail(dictionary);

                        Dictionary dictionarySub = new Dictionary();
                        BeanUtil.copyProperties(dictionary,dictionarySub);
                        dictionarySub.setParentId(dictionary.getId());
                        dictionarySub.setCode(key);
                        dictionarySub.setCnName(searchName);
                        dictionarySub.setEnName(key);
                        insertDetail(dictionarySub);

                    }
                }
            }

        }catch (Exception e){
            log.error("大家都在搜索报错:", e);
        }
        return true;
    }

    @Override
    public List<Dictionary> searchListByMe(){
        Dictionary dictionary = new Dictionary();
        dictionary.setEnabled(Boolean.TRUE);
        EntityWrapper<Dictionary> ew = new EntityWrapper<>(dictionary);
        ew.like("code","search_list",SqlLike.DEFAULT);
        ew.like("code",ContextHolder.get().getAccountId()+"",SqlLike.DEFAULT);
        return this.selectList(ew);
    }

    @Override
    public List<Dictionary> searchListByAll(){
        Dictionary search = findByCode("all_search_list");
        if(search==null){
            return Lists.newArrayList();
        }
        Dictionary dictionary = new Dictionary();
        dictionary.setEnabled(Boolean.TRUE);
        dictionary.setLayer(1);
        dictionary.setParentId(search.getId());
        EntityWrapper<Dictionary> ew = new EntityWrapper<>(dictionary);
        return this.selectList(ew);
    }

    @Override
    public Boolean searchDeleteByMe(){
        List<Dictionary> dictionaries = searchListByMe();
        if(CollectionUtil.isNotEmpty(dictionaries)){
            dictionaries.stream().forEach(d->{
                d.setEnabled(Boolean.FALSE);
                updateById(d);
            });
        }
        return true;
    }
}
