package com.yizhi.system.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.system.application.enums.ModuleType;
import com.yizhi.system.application.mapper.InternationalizationMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.system.application.service.IInternationalizationService;
import com.yizhi.system.application.service.IInternationalizationWordService;
import com.yizhi.system.application.domain.Internationalization;
import com.yizhi.system.application.vo.InternationalizationVo;
import com.yizhi.system.application.vo.InternationalizationWordVo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author taoge123
 * @since 2020-03-17
 */
@Service
public class InternationalizationServiceImpl extends ServiceImpl<InternationalizationMapper, Internationalization> implements IInternationalizationService {

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private IInternationalizationWordService internationalizationWordService;


    private final List<String> tableType = Arrays.asList("page_footer_item","page_footer_item_config");

    private Logger logger = LoggerFactory.getLogger(InternationalizationServiceImpl.class);

    @Override
    public Integer add(Internationalization a) {
        if (a != null) {
            try {
                a.setModuleName(ModuleType.valueOf(a.getModuleType()).getName());
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            return this.insert(a) == true ? 1 : 0;
        }
        return 0;
    }

    @Override
    public Page getPage(String name, String moduleName, String languageType, Integer pageNo, Integer pageSize) {
        Page page = new Page<>(pageNo, pageSize);
        Internationalization a = new Internationalization();
        a.setDeleted(0);
        a.setSiteId(ContextHolder.get().getSiteId());
        EntityWrapper wrapper = new EntityWrapper(a);
        if (!StringUtils.isEmpty(name)) {
            wrapper.like("name", name);
        }
        if (StringUtils.isEmpty(moduleName)) {
            wrapper.like("module_name", moduleName);
        }
        wrapper.orderBy("create_time",false).orderBy("id",false);
        page = this.selectPage(page, wrapper);
        List<Internationalization> records = page.getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            List<Long> ids = records.parallelStream().map(r -> r.getId()).collect(Collectors.toList());
            Map<Long, String> map = internationalizationWordService.getMap(ids,languageType);
            List<InternationalizationVo> vos = new ArrayList<>();
            for (Internationalization b : records) {
                InternationalizationVo vo = new InternationalizationVo();
                BeanUtils.copyProperties(b, vo);
                if (map != null) {
                    vo.setValue(map.get(b.getId()));
                }
                vos.add(vo);
            }
            page.setRecords(vos);
        }
        return page;
    }

    @Override
    public Integer update(InternationalizationVo vo) {
        Internationalization a = new Internationalization();
        a.setName(vo.getName());
        if (vo.getId() != null) {
            a.setId(vo.getId());
            return this.updateById(a) == true ? 1 : 0;
        }
        EntityWrapper wrapper = new EntityWrapper();
        wrapper.eq("deleted", 0);
        wrapper.eq("table_type", vo.getTableType());
        wrapper.eq("task_id", vo.getTaskId());
        return this.update(a, wrapper) == true ? 1 : 0;
    }

    @Override
    public Integer deleted(InternationalizationVo vo) {
        Internationalization a = new Internationalization();
        a.setDeleted(1);
        EntityWrapper wrapper = new EntityWrapper();
        wrapper.eq("deleted", 0);
        if (tableType.contains(vo.getTableType())) {
            wrapper.in("table_type", tableType);
            wrapper.in("task_id", vo.getTaskIds());
        } else {
            wrapper.eq("table_type", vo.getTableType());
            wrapper.eq("task_id", vo.getTaskId());

        }

        List<Internationalization> internationalizations = this.selectList(wrapper);
        if (!CollectionUtils.isEmpty(internationalizations)) {
            //先删除主体表数据
            this.update(a, wrapper);
            internationalizations.forEach(b -> {
                InternationalizationWordVo wordVo = new InternationalizationWordVo();
                wordVo.setInternationalizationId(b.getId());
                internationalizationWordService.deleted(wordVo);

            });
        } else {
            logger.info("没有找到数据！");
        }
        return 1;
    }

    @Override
    public List<Long> getIds(String tableType, List<Long> taskIds) {
        Internationalization a = new Internationalization();
        a.setTableType(tableType);
        a.setDeleted(0);
        EntityWrapper wrapper = new EntityWrapper(a);
        wrapper.in("task_id", taskIds);
        List<Internationalization> records = this.selectList(wrapper);
        if (!CollectionUtils.isEmpty(records)) {
            return records.parallelStream().map(b -> b.getId()).collect(Collectors.toList());
        }
        return null;
    }

}
