package com.yizhi.system.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.mapper.InternationalizationWordMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.system.application.service.IInternationalizationService;
import com.yizhi.system.application.service.IInternationalizationWordService;
import com.yizhi.system.application.domain.InternationalizationWord;
import com.yizhi.system.application.vo.InternationalizationWordVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author taoge123
 * @since 2020-03-17
 */
@Service
public class InternationalizationWordServiceImpl extends ServiceImpl<InternationalizationWordMapper, InternationalizationWord> implements IInternationalizationWordService {

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private IInternationalizationService internationalizationService;

    @Override
    public Integer add(InternationalizationWordVo vo) {
        if (vo != null) {
            InternationalizationWord a1 = new InternationalizationWord();
            a1.setValue(vo.getValue());
            EntityWrapper wrapper = new EntityWrapper();
            wrapper.eq("deleted", 0);
            wrapper.eq("internationalization_id", vo.getInternationalizationId());
            wrapper.eq("language_type",vo.getLanguageType());
            boolean update = this.update(a1, wrapper);
            if (update){
                return 1;
            }
            //先判断是否该国际化的value已存在
            if (!update) {
                InternationalizationWord a = new InternationalizationWord();
                RequestContext context = ContextHolder.get();

                BeanUtils.copyProperties(vo, a);
                a.setId(idGenerator.generate());
                a.setSiteId(context.getSiteId());
                a.setOrgId(context.getOrgId());
                a.setCompanyId(context.getCompanyId());
                a.setCreateTime(new Date());
                a.setCreateById(context.getAccountId());
                a.setCreateByName(context.getAccountName());
                return this.insert(a) == true ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public Map<Long, String> getMap(List<Long> internationalizationIds, String languageType) {
        if (!CollectionUtils.isEmpty(internationalizationIds)) {
            InternationalizationWord a = new InternationalizationWord();
            a.setDeleted(0);
            a.setLanguageType(languageType);
            EntityWrapper wrapper = new EntityWrapper(a);
            wrapper.in("internationalization_id", internationalizationIds);
            List<InternationalizationWord> records = this.selectList(wrapper);
            if (!CollectionUtils.isEmpty(records)) {
                return records.parallelStream().collect(Collectors.toMap(InternationalizationWord::getInternationalizationId, r -> r.getValue(), (k1, k2) -> k1));
            }
        }
        return null;
    }

    @Override
    public Integer update(InternationalizationWordVo vo) {
        return null;
    }

    @Override
    public Integer deleted(InternationalizationWordVo vo) {
        InternationalizationWord a = new InternationalizationWord();
        a.setDeleted(1);
        EntityWrapper wrapper = new EntityWrapper();
        wrapper.eq("deleted",0);
        wrapper.eq("internationalization_id", vo.getInternationalizationId());
        return this.update(a, wrapper) == true ? 1 : 0;
    }

    @Override
    public Map<Long, String> getMapByTaskIds(String tableType, List<Long> taskIds, String languageType) {

        if (!CollectionUtils.isEmpty(taskIds)) {
            //调这个接口，主要是怕不同表中Id可能重复
            List<Long> internationalizationIds = internationalizationService.getIds(tableType, taskIds);
            if (CollectionUtils.isEmpty(internationalizationIds)){
                return null;
            }
            InternationalizationWord a = new InternationalizationWord();
            a.setDeleted(0);
            a.setLanguageType(languageType);
            EntityWrapper wrapper = new EntityWrapper(a);
            wrapper.in("internationalization_id", internationalizationIds);
            List<InternationalizationWord> records = this.selectList(wrapper);
            if (!CollectionUtils.isEmpty(records)) {
                return records.parallelStream().collect(Collectors.toMap(InternationalizationWord::getTaskId, r -> r.getValue(), (k1, k2) -> k1));
            }
        }
        return null;
    }

}
