package com.yizhi.system.application.service.impl;

import java.util.Date;
import java.util.List;

import com.yizhi.system.application.mapper.LanguageClassifyMapper;
import com.yizhi.system.application.service.LanguageClassifyService;
import com.yizhi.system.application.domain.LanguageClassify;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.orm.id.IdGenerator;

@Service
public class LanguageClassifyServiceImpl extends ServiceImpl<LanguageClassifyMapper, LanguageClassify> implements LanguageClassifyService {

	@Autowired
	IdGenerator idGenerator;
	
	@Override
	public int save(LanguageClassify languageClassify) {
		RequestContext context = ContextHolder.get();
		LanguageClassify exitsNameClassify = new LanguageClassify();
		exitsNameClassify.setName(languageClassify.getName());
		exitsNameClassify.setDeleted(0);
		int count = exitsNameClassify.selectCount(new EntityWrapper<LanguageClassify>(exitsNameClassify));
		if (count>0) {
			return 2;
		}
		Long id = idGenerator.generate();
		languageClassify.setId(id);
		int sort = this.baseMapper.selectSort();
		languageClassify.setSort(++sort);
		languageClassify.setCreateById(context.getAccountId());
		languageClassify.setCreateByName(context.getAccountName());
		languageClassify.setCreateTime(new Date());
		return this.baseMapper.insert(languageClassify);
	}

	@Override
	public int update(LanguageClassify languageClassify) {
		LanguageClassify classify = languageClassify.selectById();
		if (classify==null) {
			return 0;
		}
		LanguageClassify exitsNameClassify = new LanguageClassify();
		exitsNameClassify.setName(languageClassify.getName());
		exitsNameClassify.setDeleted(0);
		EntityWrapper<LanguageClassify> wrapper = new EntityWrapper<LanguageClassify>(exitsNameClassify);
		wrapper.notIn("id", classify.getId());
		int count = exitsNameClassify.selectCount(wrapper);
		if (count>0) {
			return 2;
		}
		return this.baseMapper.updateById(languageClassify);
	}

	@Override
	public int delete(Long id) {
		LanguageClassify classify = this.baseMapper.selectById(id);
		if (classify==null) {
			return 0;
		}
		classify.setDeleted(1);
		return this.baseMapper.updateById(classify);
	}

	@Override
	public int sort(List<LanguageClassify> list) {
        if (list.size() == 2) {
        	LanguageClassify classifyFirst = list.get(0);
        	LanguageClassify classifyLast = list.get(1);
            if(classifyFirst.getSort().equals(classifyLast.getSort())){
                classifyLast.setSort(classifyLast.getSort().intValue()-1);
            }
            this.baseMapper.updateById(classifyFirst);
            this.baseMapper.updateById(classifyLast);
        }
        return 1;
	}
}
