package com.yizhi.system.application.service.impl;

import com.yizhi.system.application.enums.OrderField;
import com.yizhi.system.application.mapper.SensitiveWordMapper;
import com.yizhi.system.application.service.ISensitiveWordService;
import com.yizhi.system.application.domain.SensitiveWord;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.util.application.constant.ReturnCode;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author moni.yin123
 * @since 2018-04-08
 */
@Service
public class SensitiveWordServiceImpl extends ServiceImpl<SensitiveWordMapper, SensitiveWord> implements ISensitiveWordService {
	@Autowired
	SensitiveWordMapper sensitiveWordMapper;
	@Autowired
	IdGenerator idGenerator;
	
	@Override
	@Transactional
	public Boolean save(SensitiveWord sensitiveWord) {
		if(sensitiveWordMapper.countExistName(0L, sensitiveWord.getCompanyId(), sensitiveWord.getName())>0){
			throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(),"敏感词已存在");
		}
		sensitiveWord.setId(idGenerator.generate());
		sensitiveWord.setCompanyId(sensitiveWord.getCompanyId());
		if(this.insert(sensitiveWord)){
			return true;
		}else{
			throw new BizException(ReturnCode.SAVE_FAIL.getCode(),ReturnCode.SAVE_FAIL.getMsg());
		}
	}

	@Override
	@Transactional
	public Boolean update(SensitiveWord sensitiveWord) {
		if(StringUtils.isNotEmpty(sensitiveWord.getName())){
			if(sensitiveWordMapper.countExistName(sensitiveWord.getId(), sensitiveWord.getCompanyId(), sensitiveWord.getName())>0){
				throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(),"敏感词已存在");
			}
		}
		if(this.updateById(sensitiveWord)){
			return true;
		}else{
			throw new BizException(ReturnCode.UPDATE_FAIL.getCode(),ReturnCode.UPDATE_FAIL.getMsg());
		}
	}

	@Override
	@Transactional
	public Boolean delete(Long id) {
		SensitiveWord sensitiveWord = new SensitiveWord();
		sensitiveWord.setId(id);
		sensitiveWord.setDeleted(true);
		if(this.updateById(sensitiveWord)){
			return true;
		}else{
			throw new BizException(ReturnCode.DELETE_FAIL.getCode(),ReturnCode.DELETE_FAIL.getMsg());
		}
	}

	@Override
	public Boolean checkName(Long id,Long companyId,String name) {
		if(sensitiveWordMapper.countExistName(id,companyId,name)>0){
			throw new BizException(ReturnCode.RESOURCE_EXIST.getCode(),"敏感词已存在");
		}else{
			return true;
		}
	}

	@Override
	public Page<SensitiveWord> list(SensitiveWord sensitiveWord, Page<SensitiveWord> page) {
		page.setOrderByField(OrderField.CREATETIME.getCode());
		page.setAsc(false);
		//检测是否根据名称查询，如果是，则支持模糊查询
		String name=null;
		if(StringUtils.isNotEmpty(sensitiveWord.getName())){
			name=sensitiveWord.getName();
		}
		sensitiveWord.setName(null);
		Wrapper<SensitiveWord> wrapper=QueryUtil.condition(sensitiveWord);
		if(null!=name){
			wrapper.like("name", name);
		}
		return this.selectPage(page, wrapper);
	}

}
