package com.yizhi.system.application.service.impl;

import java.util.List;

import com.yizhi.system.application.mapper.TemplateColumnMapper;
import com.yizhi.system.application.mapper.TemplateMapper;
import com.yizhi.system.application.service.ITemplateService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.file.domain.Template;
import com.yizhi.core.application.file.domain.TemplateColumn;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.util.application.constant.ReturnCode;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-03-27
 */
@Service
public class TemplateServiceImpl extends ServiceImpl<TemplateMapper, Template> implements ITemplateService {
	
	@Autowired
	TemplateMapper templateMapper;
	@Autowired
	TemplateColumnMapper templateColumnMapper;
	
	@Override
	public Template findByName(String name) {
		Template condition=new Template();
		condition.setEnabled(true);
		condition.setName(name);
		condition.setCompanyId(ContextHolder.get().getCompanyId());
		List<Template> templates=templateMapper.selectList(QueryUtil.condition(condition));
		if(CollectionUtils.isNotEmpty(templates)){
			Template template=templates.get(0);
			TemplateColumn columnCondition=new TemplateColumn();
			columnCondition.setTemplateId(template.getId());
			columnCondition.setEnabled(true);
			EntityWrapper<TemplateColumn> wrapper=QueryUtil.condition(columnCondition);
			wrapper.orderBy(true, "sort_no");
			List<TemplateColumn> columns=templateColumnMapper.selectList(wrapper);
			if(CollectionUtils.isNotEmpty(columns)){
				template.setColumns(columns);
				return template;
			}else{
				throw new BizException(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
			}			
		}else{
			throw new BizException(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
		}
	}

}
