package com.yizhi.system.application.task;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.service.ILoginExportService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.vo.domain.Organization;
import com.yizhi.system.application.vo.LoginUserChartRepVO;
import com.yizhi.system.application.vo.LoginUserExportVO;
import com.yizhi.system.application.vo.LoginUserOrgExportVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 22:01 2018/8/29
 * @Modified By
 */

/**
 * 报表导出
 */
@Component
public class LoginExportAsy extends AbstractDefaultTask<String, Map<String,Object>> {

    private static final Logger logger = LoggerFactory.getLogger(LoginExportAsy.class);

    static final String BY_ORG_EXPORT="byOrgExport";

    @Autowired
    private ILoginExportService loginExportService;

    @Autowired
    private IOrganizationService organizationService;

    @Autowired
    DomainConverter domainConverter;
    /*@Autowired
    private ReportMarketingCourseExport export;*/

    @Override
    protected String execute(Map<String, Object> param) {
        RequestContext requestContext = (RequestContext)param.get("requestContext");
        ContextHolder.set(requestContext);
        logger.info("########################################报表统计导出开始,上下文信息={}", JSON.toJSONString(requestContext));
        String business = (String) param.get("business");// 获取业务标识
        String startDate = (String) param.get("startDate");
        String endDate = (String) param.get("endDate");
        List<Object[]> exportBodyData = new ArrayList<>();//导出的主体数据
        String[] titles = null; // 标题字段列表
        String exportName = ""; // 表头名称
        int cloumSize = 0;
        String exportDesc = "统计周期："+ LocalDate.parse(startDate, DateTimeFormatter.ISO_DATE).
                format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))+"～"+
                LocalDate.parse(endDate, DateTimeFormatter.ISO_DATE).
                        format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));// 报表统计说明

        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter=DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
        Date submitTime = Date.from(now.atZone(ZoneId.systemDefault()).toInstant());//任务提交时间
        Long taskId = submitTime.getTime();//任务标识
        //String serialNo = UUID.randomUUID().toString();//任务编号
        String serialNo = (String) param.get("serialNo");
        Long submitterId = requestContext.getAccountId();//任务提交人id
        Long siteId = requestContext.getSiteId();
        Long companyId = requestContext.getCompanyId();//公司id
        String taskName = null;//任务名称
        TaskContext taskContext = null;
        String kwd = (String) param.get("kwd");
        LoginUserChartRepVO vo = new LoginUserChartRepVO();
        vo.setStartDate(startDate);
        vo.setEndDate(endDate);
        vo.setKwd(kwd);
        vo.setRequestContext(requestContext);
        logger.info("########################################报表统计导出准备进入业务系统");
        if(StringUtils.equals(BY_ORG_EXPORT,business)){
            logger.info("########################################按组织导出");
            exportName = "部门登录情况统计";
            taskName = exportName+"_"+serialNo;
            // 获取部门编码或名称关联的orgId
            taskContext = new TaskContext(taskId,serialNo,taskName,submitterId,submitTime,siteId,companyId);
            working(taskContext);
            if(StringUtils.isBlank(startDate) || StringUtils.isBlank(endDate)){
                fail(taskContext, "导出报表的查询时间有误，请重新选择日期进行导出");
            }
            titles = new String[]{"部门编码","部门名称","总用户数","启用用户数","停用用户数","登录人数","登录人次","所在组织架构"};
            cloumSize = titles.length;

            List<LoginUserOrgExportVO> result = this.loginLogByOrgExp(vo);

            for(LoginUserOrgExportVO item : result){
                List<Object> itemData = new ArrayList<>();
                itemData.add(item.getOrgCode());
                itemData.add(item.getOrgName());
                itemData.add(item.getUserSumNum());
                itemData.add(item.getEnableUserNum());
                itemData.add(item.getStopUserNum());
                itemData.add(item.getLoginUserNum());
                itemData.add(item.getLoginVisit());
                List<String> upOrgs = item.getUpOrgNames();
//                if(CollectionUtils.isNotEmpty(upOrgs) && upOrgs.size()>1){
//                    if(upOrgs.size()>20){
//                        itemData.addAll(upOrgs.stream().limit(10).collect(Collectors.toList()));
//                    }else{
//                        upOrgs.remove(upOrgs.size()-1);
//                        itemData.addAll(upOrgs);
//                    }
//                }
                if (CollectionUtils.isNotEmpty(upOrgs)){
                    String orgNames = "";
                    for (String s : upOrgs){
                        if (StringUtils.isNotBlank(orgNames)){
                            orgNames = orgNames + "/" + s;
                        }else {
                            orgNames = orgNames + s;
                        }
                    }
                    itemData.add(orgNames);
                }else {
                    itemData.add(item.getOrgName());
                }
                exportBodyData.add(itemData.toArray());
            }
            logger.info("########################################按课组织出数据查询完毕");
        }else {
            logger.info("########################################按用户导出");
            exportName = "用户登录情况统计";
            taskName = exportName+"_"+serialNo;
            // 获取部门编码或名称关联的orgId
            taskContext = new TaskContext(taskId,serialNo,taskName,submitterId,submitTime,siteId,companyId);
            working(taskContext);
            if(StringUtils.isBlank(startDate) || StringUtils.isBlank(endDate)){
                fail(taskContext, "导出报表的查询时间有误，请重新选择日期进行导出");
            }
            titles = new String[]{"用户名","姓名","工号","登录次数","最后登录时间",
                    "用户当前状态","所在部门","所在组织架构"};
            cloumSize = titles.length;
            List<LoginUserExportVO> result = this.loginLogByAccountExp(vo);
            for(LoginUserExportVO item : result){
                List<Object> itemData = new ArrayList<>();
                itemData.add(item.getUserName());
                itemData.add(item.getUserFullName());
                itemData.add(item.getWorkNum());
                itemData.add(item.getLoginVisit());
                itemData.add(item.getLastLoginDate());
                itemData.add(item.getUserStatus());
                itemData.add(item.getOrgName());
                List<String> orgs = item.getUpOrgNames();
//                if(CollectionUtils.isNotEmpty(orgs)){
//                    if(orgs.size()>20){
//                        itemData.addAll(orgs.stream().limit(10).collect(Collectors.toList()));
//                    }else{
//                        itemData.addAll(orgs);
//                    }
//                }
                if (CollectionUtils.isNotEmpty(orgs)){
                    String orgNames = "";
                    for (String s : orgs){
                        if (StringUtils.isNotBlank(orgNames)){
                            orgNames = orgNames + "/" + s;
                        }else {
                            orgNames = orgNames + s;
                        }
                    }
                    itemData.add(orgNames);
                }else {
                    itemData.add(item.getOrgName());
                }
                exportBodyData.add(itemData.toArray());
            }
            logger.info("########################################按用户导出数据查询完毕");
        }

        logger.info("########################################按用户导出数据查询数据={}条;任务上下文={}",
                exportBodyData.size(),JSON.toJSONString(taskContext));
        // 生成excel
        String fileName = taskName+".xls";

        String upLoadUrl = createExcel(
                exportBodyData, titles, exportName,
                cloumSize, exportDesc,fileName);
        success(taskContext,"成功", upLoadUrl);
        logger.info("########################################报表统计导出完成,下载url="+upLoadUrl);
        return "ok";
    }

    /**
     * 登陆按用户统计的数据
     * @param vo
     * @return
     */
    private List<LoginUserExportVO> loginLogByAccountExp(LoginUserChartRepVO vo){
        List<LoginUserExportVO> retData = null;

        String startDate = vo.getStartDate();
        String endDate = vo.getEndDate();
        String kwd = vo.getKwd();
        RequestContext reques = vo.getRequestContext();
        List<Long> siteAdminOrgs = reques.getOrgIds();
        if(reques.isAdmin()){
            siteAdminOrgs = Arrays.asList(-1L);
            Set<Long> siteOrg = organizationService.getOrgIdsInSite(reques.getSiteId(),reques.getCompanyCode(),reques.getSiteCode());
            if(CollectionUtils.isNotEmpty(siteOrg)){
                siteAdminOrgs = Arrays.asList(siteOrg.toArray(new Long[]{}));
            }
        }else {
            if(CollectionUtils.isEmpty(siteAdminOrgs)){
                return null;
            }
		}
        Page<LoginUserExportVO> data = loginExportService.loginLogByAccount(startDate,endDate,
                kwd,null,null,reques.getCompanyId(),reques.getSiteId(),reques.getOrgIds(),siteAdminOrgs);
        retData = data.getRecords();
        if(CollectionUtils.isNotEmpty(retData)){
        	Map<Long, List<String>> map = new HashMap<Long, List<String>>();
            for(LoginUserExportVO obj : retData){
            	if (!map.containsKey(obj.getOrgId())) {
            		List<String> list = organizationService.listParentNameIds(obj.getOrgId());
            		obj.setUpOrgNames(list);
            		map.put(obj.getOrgId(), list);
				}
                obj.setUpOrgNames(map.get(obj.getOrgId()));
            }
            return retData;
        }
        return null;
    }

    /**
     * 登陆按组织统计的数据
     * @param vo
     * @return
     */
    private List<LoginUserOrgExportVO> loginLogByOrgExp(LoginUserChartRepVO vo){
        //List<LoginUserOrgExportVO> redata = null;

        String startDate = vo.getStartDate();
        String endDate = vo.getEndDate();
        String kwd = vo.getKwd();
        RequestContext reques = vo.getRequestContext();
        List<Long> siteAdminOrgs = reques.getOrgIds();
        if(reques.isAdmin()){
            siteAdminOrgs = Arrays.asList(-1L);
            Set<Long> siteOrg = organizationService.getOrgIdsInSite(reques.getSiteId(),reques.getCompanyCode(),reques.getSiteCode());
            if(CollectionUtils.isNotEmpty(siteOrg)){
                siteAdminOrgs = Arrays.asList(siteOrg.toArray(new Long[]{}));
            }
        }else {
            if(CollectionUtils.isEmpty(siteAdminOrgs)){
                return null;
            }
		}

        // 查询组织分页信息
        EntityWrapper<com.yizhi.system.application.domain.Organization> ewOrg = QueryUtil.condition(new com.yizhi.system.application.domain.Organization());
        ewOrg.in("id",siteAdminOrgs);
        if(StringUtils.isNotBlank(kwd)){
            ewOrg.andNew().like("code",kwd, SqlLike.DEFAULT).or().like("name",kwd, SqlLike.DEFAULT);
        }
        ewOrg.orderBy("id",false);
        List<com.yizhi.system.application.domain.Organization> pageData = organizationService.selectList(ewOrg);
        List<Organization> list = domainConverter.toDOList(pageData, Organization.class);
        // 获取各个组织的下级组织
        Map<String,Organization> countMap = new HashMap<>();
        Set<Long> selectOrgs = new HashSet();
        for(Organization item : list){
            Set<Long> itemChidren = organizationService.listChildrenId(Arrays.asList(item.getId()));
            String key = ","+StringUtils.join(itemChidren,",")+",";
            countMap.put(key,item);
            selectOrgs.addAll(itemChidren);
        }
        List<Long> longList = new ArrayList<>(selectOrgs);

        Page<LoginUserOrgExportVO> data = loginExportService.loginLogByOrg(startDate,endDate,
                kwd,null,null,reques.getCompanyId(),reques.getSiteId(),longList);

        List<LoginUserOrgExportVO> allData = data.getRecords();

        // 最后返回的List对象数据
        List<LoginUserOrgExportVO> retList = new ArrayList<>();

        // 循环按组织分组以后包含下级组织和当前组织id的key
        for(Map.Entry<String,Organization> itemVal : countMap.entrySet()){

            // 获取当前组织的所属id
            Organization organizationTemp = itemVal.getValue();
            Long orgId = organizationTemp.getId();

            // 获取包含下级组织的key
            String forOrgId = itemVal.getKey();
            //logger.info("查询的key={}",forOrgId);
            // Objects.equals(a，b),如果两个参数都为 null， Objects.equals(a，b) 调用将返回 true ; 如果其中一个参数为 null ,则返回 false ; 否则，如果两个参数都不为 null， 则调用 a.equals(b)
            //testList.removeIf(test->test.startsWith("1")); 排除，filter保留为true
            Map<Long,LoginUserOrgExportVO> gList = allData.stream().filter(objItem->forOrgId.indexOf((","+objItem.getOrgId().toString()+","))>=0)
                    .collect(Collectors.toMap(key1->key1.getOrgId(),val1->val1));


            //logger.info("获取root的orgId={}",organizationTemp.getId());
            LoginUserOrgExportVO loginUserOrgExportVO = gList.get(orgId);
            // 新建数据存储对象
            LoginUserOrgExportVO loginUserOrgExportVONew = new LoginUserOrgExportVO();
            loginUserOrgExportVONew.setOrgId(organizationTemp.getId());
            loginUserOrgExportVONew.setOrgName(organizationTemp.getName());
            loginUserOrgExportVONew.setOrgCode(organizationTemp.getCode());

            if(loginUserOrgExportVO == null){
                loginUserOrgExportVONew.setLoginUserNum(0L);
                loginUserOrgExportVONew.setStopUserNum(0L);
                loginUserOrgExportVONew.setEnableUserNum(0L);
                loginUserOrgExportVONew.setUserSumNum(0L);
                loginUserOrgExportVONew.setLoginVisit(0L);
                loginUserOrgExportVONew.setUpOrgNames(organizationService.listParentNameIds(orgId));
                retList.add(loginUserOrgExportVONew);
                continue;
            }

            // 循环追加子组织的统计信息
            long userSumNum = loginUserOrgExportVO.getUserSumNum();
            long enableUserNum = loginUserOrgExportVO.getEnableUserNum();
            long stopUserNum = loginUserOrgExportVO.getStopUserNum();
            long loginUserNum = loginUserOrgExportVO.getLoginUserNum();
            long loginVisit = loginUserOrgExportVO.getLoginVisit();
            gList.remove(organizationTemp.getId());
            Collection<LoginUserOrgExportVO> voCollection = gList.values();
            for(LoginUserOrgExportVO loginUserOrgExportVO1 : voCollection){
                userSumNum = userSumNum+loginUserOrgExportVO1.getUserSumNum().longValue();
                enableUserNum = enableUserNum+loginUserOrgExportVO1.getEnableUserNum().longValue();
                stopUserNum = stopUserNum + loginUserOrgExportVO1.getStopUserNum().longValue();
                loginUserNum = loginUserNum+loginUserOrgExportVO1.getLoginUserNum().longValue();
                loginVisit = loginVisit+loginUserOrgExportVO1.getLoginVisit().longValue();
            }
            loginUserOrgExportVONew.setUserSumNum(userSumNum);
            loginUserOrgExportVONew.setEnableUserNum(enableUserNum);
            loginUserOrgExportVONew.setStopUserNum(stopUserNum);
            loginUserOrgExportVONew.setLoginUserNum(loginUserNum);
            loginUserOrgExportVONew.setLoginVisit(loginVisit);
            loginUserOrgExportVONew.setUpOrgNames(organizationService.listParentNameIds(orgId));
            retList.add(loginUserOrgExportVONew);
        }

        return retList;
    }


    /**
     * 生成excel
     * @param exportBodyData 导出的主体数据
     * @param titles 标题头
     * @param exportName 导出顶上大标题
     * @param cloumSize 列大小
     * @param exportDesc 导出的小标题说明
     */
    public static String createExcel(List<Object[]> exportBodyData, String[] titles,
                                     String exportName, int cloumSize, String exportDesc,
                                     String fileName) {

//        String requestPath = "/Users/dingxiaowei/aaa";
        String requestPath= FileConstant.SAVE_PATH;
        File fileDir=new File(requestPath);
        if(!fileDir.exists()) {
            fileDir.mkdir();
        }
        //String fileDir= "D:\\data";
        String filePath = fileDir+File.separator+fileName;
        String upLoadUrl = "";
        File file = new File(filePath);
        try(HSSFWorkbook workbook = new HSSFWorkbook();
            FileOutputStream os = new FileOutputStream(filePath)){
            // 创建第一个sheet页
            Sheet sheet = workbook.createSheet(exportName);
            //sheet.setDefaultColumnWidth(20);//设置sheet页默认列宽度设置成100个字符宽度

            int index = 0;
            if(StringUtils.isNotBlank(exportName)){
                // 设置单元格的高度，其实就是设置行的高度
                // HeightInPoints的单位是点，而Height的单位是1/20个点，所以Height的值永远是HeightInPoints的20倍
                Row row1 = sheet.createRow(index);
                //row.setHeight(Short.valueOf("400"));//20*200
                Cell exportNameCell = row1.createCell(0);
                exportNameCell.setCellValue(exportName);
                HSSFCellStyle exportNameStye = workbook.createCellStyle();
                HSSFFont headfont = workbook.createFont();
                //设置字体大小
                headfont.setFontHeightInPoints((short) 18);
                // //粗体显示
                headfont.setBold(true);
                exportNameStye.setFont(headfont);
                exportNameStye.setAlignment(HorizontalAlignment.CENTER);//居中
                exportNameStye.setVerticalAlignment(VerticalAlignment.CENTER);//设置垂直居中
                exportNameCell.setCellStyle(exportNameStye);

                //sheet.createRow(index).setRowStyle();
                //合并列
                CellRangeAddress region=new CellRangeAddress(index, index, 0, cloumSize-1);
                sheet.addMergedRegion(region);
                index++;
            }
            if(StringUtils.isNotBlank(exportDesc)){
                Cell exportDescCell = sheet.createRow(index).createCell(0);
                exportDescCell.setCellValue(exportDesc);
                HSSFCellStyle exportDescStye = workbook.createCellStyle();
                HSSFFont headfont = workbook.createFont();
                //设置字体大小
                headfont.setFontHeightInPoints((short) 14);
                // //粗体显示
                headfont.setBold(true);
                exportDescStye.setFont(headfont);
                exportDescStye.setAlignment(HorizontalAlignment.LEFT);
                exportDescStye.setVerticalAlignment(VerticalAlignment.CENTER);//设置垂直居中
                exportDescCell.setCellStyle(exportDescStye);
                //sheet.createRow(index).setRowStyle();
                //合并列
                CellRangeAddress region=new CellRangeAddress(index, index, 0, cloumSize-1);
                sheet.addMergedRegion(region);
                index++;
            }
            if(titles!=null){
                Row titleRow = sheet.createRow(index);
                HSSFCellStyle titlesStye = workbook.createCellStyle();
                HSSFFont headfont = workbook.createFont();
                //设置字体大小
                headfont.setFontHeightInPoints((short) 12);
                // //粗体显示
                headfont.setBold(true);
                titlesStye.setFont(headfont);
                titlesStye.setAlignment(HorizontalAlignment.CENTER);
                titlesStye.setVerticalAlignment(VerticalAlignment.CENTER);
                //titleRow.setRowStyle(titlesStye);
                for(int k =0;k<titles.length;k++){
                    //sheet.autoSizeColumn(k, true);// 列自适应宽度
                    Cell titleCell = titleRow.createCell(k);
                    titleCell.setCellStyle(titlesStye);
                    titleCell.setCellValue((String)titles[k]);
                    sheet.setColumnWidth(k,20 * 256);
                }

                index++;
            }
            int writeIndex = index;
            for(int rownum = 0; rownum < exportBodyData.size(); rownum++){
                Row row = sheet.createRow(writeIndex);
                Object[] itemData = exportBodyData.get(rownum);
                int cellnumSum = itemData.length;


                for(int cellnum = 0; cellnum < cellnumSum; cellnum++){
                    //sheet.setColumnWidth(cellnum,100 * 256);
                    Cell cell = row.createCell(cellnum);
                    Object valObj = itemData[cellnum];
                    String val = valObj == null?" ":valObj.toString();
                    cell.setCellValue(val);
                }
                writeIndex++;
                index++;
                if(index % 60000 == 0){
                    writeIndex = 0;
                    sheet = workbook.createSheet(exportName+(index/60000));
                }
            }
            //ByteArrayOutputStream os = new ByteArrayOutputStream();
            workbook.write(os);
            //阿里云返回url
            upLoadUrl = OssUpload.upload(filePath, fileName);
            file.delete();
            //success(taskContext,"成功", upLoadUrl);
            //data = os.toByteArray();
        }catch (IOException e){
            logger.info("生成excel发送异常{}",e);
            return null;
        }
        return upLoadUrl;
    }
}
