package com.yizhi.system.application.task;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.system.application.constant.OutsideUserMsg;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.domain.*;
import com.yizhi.system.application.service.*;
import com.yizhi.system.application.service.using.OrganizationIndexService;
import com.yizhi.system.application.util.SaltUtil;
import com.yizhi.util.application.encrypt.ShaEncrypt;
import com.yizhi.system.application.vo.OutsideUserSyncVO;
import com.yizhi.system.application.vo.OutsideUserVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Component
public class OutsideUserSyncTask extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger logger = LoggerFactory.getLogger(OutsideUserSyncTask.class);

    @Autowired
    private IdGenerator idGenerator;

    private static final String SPLIT = "##";

    private static final String ORG_INFO_SPLIT = "~~";

    private static final Long ACCOUNT_ID = 999L;

    @Autowired
    private SwhyKeyService swhyKeyService;

    @Autowired
    private IOutsideRootOrgsService outsideRootOrgsService;

    @Autowired
    private IOrganizationService organizationService;

    @Autowired
    private IAccountService accountService;

    @Autowired
    private OrganizationIndexService organizationIndexService;

    @Autowired
    private IOutsideOperatorRecodeService outsideOperatorRecodeService;


    /**
     * 具体业务执行方法
     *
     * @param param 业务参数
     * @return 返回泛型中指定的类型
     */
    @Override
    protected String execute(Map<String, Object> param) {

        OutsideUserSyncVO outsideUserSyncVO = (OutsideUserSyncVO)param.get("requestParam");
        // 获取企业id和站点id
        Long siteId = (Long) param.get("siteId");
        String siteCode = (String) param.get("siteCode");
        Long companyId = (Long) param.get("companyId");
        String companyCode = (String) param.get("companyCode");


        String requestBody = JSON.toJSONString(param);
        logger.info("请求的对接数据={}", requestBody);

        OutsideOperatorRecode outsideOperatorRecode = new OutsideOperatorRecode();

        Path saveFilePath = null;

        try {
            //LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"))
            String path = FileConstant.SAVE_PATH + File.separator + "outsideUser" + File.separator + companyCode + File.separator + siteCode;
            path += File.separator + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH"));
            Path filePath = Paths.get(path);
            if(Files.notExists(filePath)){
                Files.createDirectories(filePath);
            }
            String fileName = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH_mm_ss_SSS"))+".txt";
            saveFilePath = Paths.get(filePath.toAbsolutePath().toString(), fileName);
            Files.write(saveFilePath, requestBody.getBytes());
            //阿里云返回url
            //upLoadUrl = OssUpload.upload(path, fileName);

            outsideOperatorRecode.setId(idGenerator.generate());
            outsideOperatorRecode.setCompanyCode(companyCode);
            outsideOperatorRecode.setCompanyId(companyId);
            outsideOperatorRecode.setSiteCode(siteCode);
            outsideOperatorRecode.setSiteId(siteId);
            outsideOperatorRecode.setRequestContextPath(Paths.get(filePath.toAbsolutePath().toString(), fileName).toAbsolutePath().toString());
            outsideOperatorRecode.setType(1);
            outsideOperatorRecode.setStatus(0);

        }catch (IOException e){
            logger.info("生成文件异常：{}",e);
            //return Response.fail(OutsideUserMsg.SYSTEM_ERROR.getCode(),OutsideUserMsg.SYSTEM_ERROR.getName());
            outsideOperatorRecode.setStatus(1);
            outsideOperatorRecode.setDesc("生成备份文件失败！");
        }


        try {

            boolean isNewOrg = false;
            // 首先验证appId是否是平台的合法参数
            String appId = outsideUserSyncVO.getAppId();
            SwhyKey swhyKeyConfig = getSwhyKey(companyId, appId);
            // 获取相关配置
            Integer rsaState = swhyKeyConfig.getRsaState();
            String privateKey = swhyKeyConfig.getPrivateKey();

            // 遍历用户信息
            List<OutsideUserVO> users = outsideUserSyncVO.getUsers();

            // 获取对接组织root的列表
            Map<String, Long> orgSelectd = new HashMap<>();
            String orgRoot = "";
            EntityWrapper<OutsideRootOrgs> ewOro = QueryUtil.condition(new OutsideRootOrgs());
            ewOro.eq("company_id",companyId).eq("site_id",siteId);
            OutsideRootOrgs dbOutsideRootOrgs = outsideRootOrgsService.selectOne(ewOro);
            String dbOrgIds = StringUtils.trimToEmpty(dbOutsideRootOrgs.getRootOrgs());
            if(dbOutsideRootOrgs != null && !StringUtils.EMPTY.equals(dbOrgIds)){
                String[] dbOrgIdsArr = dbOrgIds.split(SPLIT);
                for(String itemOrgId : dbOrgIdsArr){
                    String orgIdTem = StringUtils.trimToEmpty(itemOrgId);
                    if(!StringUtils.EMPTY.equals(orgIdTem)){
                        Organization dbOrganization = organizationService.selectById(Long.valueOf(orgIdTem));
                        orgRoot += dbOrganization.getName()+SPLIT;
                        orgSelectd.put(orgRoot, Long.valueOf(orgIdTem));
                    }
                }
            }
            // 检查必须字段并解密字段信息
            decryptUserInfo(rsaState, privateKey, users,orgRoot);
            logger.info("解密请求数据 = {}", JSON.toJSONString(users));
            // 开始同步用户
            // 1 查看有多少用户组
            Set<String> orgGroups = users.stream().parallel().map(orgG->orgG.getOrgNames()).collect(Collectors.toSet());
            isNewOrg = syncOrg(siteCode, companyId, companyCode, orgSelectd, orgGroups);
            logger.info("用户组的列表 = {}", JSON.toJSONString(orgSelectd));

            // 2 开始处理用户
            // 查询数据库的某企业下启用的用户列表
            List<OutsideUserVO> existsOutsideUserVO = accountService.getCompanyOutsideUsers(companyId, null);
            if(CollectionUtils.isEmpty(existsOutsideUserVO)){ // 首次同步（全是新增用户）
                logger.info("数据库不包含用户，开始新增用户");
                addUsers(companyId, siteId, users, orgSelectd, true);
            } else {
                logger.info("数据库包含用户，开始新增用户");
                // 把同步的用户的组织id设置并获取用户名的set集合
                Map<String,OutsideUserVO> syncUserNames = new HashMap<>();
                logger.info("组织架构={}", JSON.toJSONString(orgSelectd));
                for(OutsideUserVO syncUser : users){
                    logger.info("遍历每一个用户={}", JSON.toJSONString(syncUser));
                    syncUser.setOrgId(orgSelectd.get(syncUser.getOrgNames()));
                    syncUser.setSiteId(siteId);
                    syncUserNames.put(syncUser.getName(),syncUser);
                }
                Map<String,OutsideUserVO> dbUserNames = existsOutsideUserVO.stream().parallel()
                        .collect(Collectors.toMap(keyObj->keyObj.getName(), valObj -> valObj));
                // 准备更新，添加，删除操作
                Set<String> syncUserNameSet = syncUserNames.keySet();
                Set<String> dbUserNameSet = dbUserNames.keySet();
                // 需要更新的用户信息
                Set<String> updateUsers = new HashSet<>();
                updateUsers.addAll(syncUserNameSet);
                updateUsers.retainAll(dbUserNameSet);
                if(!CollectionUtils.isEmpty(updateUsers)){
                    String updateStatus = updateUsers(syncUserNames, dbUserNames, updateUsers, siteId, saveFilePath);
                    if(!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(updateStatus))){
                        outsideOperatorRecode.setStatus(1);
                        outsideOperatorRecode.setDesc(updateStatus);
                    }
                }
                // 需要创建用户
                Set<String> newUsers = new HashSet<>();
                newUsers.addAll(syncUserNameSet);
                newUsers.removeAll(dbUserNameSet);
                if(!CollectionUtils.isEmpty(newUsers)){
                    List<OutsideUserVO> addUsers = new ArrayList<>();
                    for(String addUserName : newUsers){
                        addUsers.add(syncUserNames.get(addUserName));
                    }
                    addUsers(companyId, siteId, addUsers, null, false);
                }
            }

            if (isNewOrg) {
                // 添加组织索引信息
                try {
                    organizationIndexService.addInitTask(companyId);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }catch (BizException e){
            outsideOperatorRecode.setStatus(1);
            outsideOperatorRecode.setDesc(e.getMsg());
            logger.info("业务异常={}", JSON.toJSONString(e));
            //return Response.fail(e.getCode(),e.getMsg());
        }catch (Exception e){
            outsideOperatorRecode.setStatus(1);
            outsideOperatorRecode.setDesc(e.getMessage());
            logger.info("系统异常={}", e);
            //return Response.fail(OutsideUserMsg.SYSTEM_ERROR.getCode(),OutsideUserMsg.SYSTEM_ERROR.getName());
        }
        outsideOperatorRecodeService.insert(outsideOperatorRecode);
        return null;
    }

    /**
     * 获取appId 配置
     * @param companyId
     * @param appId
     * @return
     * @throws BizException
     */
    public SwhyKey getSwhyKey(Long companyId, String appId) throws BizException {
        EntityWrapper<SwhyKey> ewSk = QueryUtil.condition(new SwhyKey());
        ewSk.eq("company_id", companyId).eq("uuid",appId);
        SwhyKey swhyKeyConfig = swhyKeyService.selectOne(ewSk);
        if(swhyKeyConfig == null){ //appId 不存在
            throw new BizException(OutsideUserMsg.APPID_NOT_EXIST.getCode(),OutsideUserMsg.APPID_NOT_EXIST.getName());
        }
        // 验证appId是否过期
        Date appIdExpireTime = swhyKeyConfig.getExpireTime();
        if(appIdExpireTime.getTime() < System.currentTimeMillis()){
            throw new BizException(OutsideUserMsg.APPID_EXPIRED_TIME.getCode(),OutsideUserMsg.APPID_EXPIRED_TIME.getName());
        }
        return swhyKeyConfig;
    }

    /**
     * 检查非空字段并解密信息（如果配置了加密）
     * @param rsaState
     * @param privateKey
     * @param users
     */
    private static void decryptUserInfo(Integer rsaState, String privateKey, List<OutsideUserVO> users, String orgRoot) {
        if(CollectionUtils.isEmpty(users)){
            throw new BizException(OutsideUserMsg.USERS_IS_EMPTY.getCode(),OutsideUserMsg.USERS_IS_EMPTY.getName());
        }
        for(OutsideUserVO user : users){
            // 验证必须字段
            String name = user.getName();
            String fullName = user.getFullName();
            String orgNames = user.getOrgNames();
            String status = user.getStatus();
            if(StringUtils.trimToEmpty(name).isEmpty()){
                throw new BizException(OutsideUserMsg.USER_NAME_IS_EMPTY.getCode(),OutsideUserMsg.USER_NAME_IS_EMPTY.getName());
            }
            if(StringUtils.trimToEmpty(fullName).isEmpty()){
                throw new BizException(OutsideUserMsg.USER_FULL_NAME_IS_EMPTY.getCode(),OutsideUserMsg.USER_FULL_NAME_IS_EMPTY.getName());
            }
            if(StringUtils.trimToEmpty(orgNames).isEmpty()){
                throw new BizException(OutsideUserMsg.USER_ORG_NAME_IS_EMPTY.getCode(),OutsideUserMsg.USER_ORG_NAME_IS_EMPTY.getName());
            }
            if(StringUtils.trimToEmpty(orgNames).isEmpty()){
                throw new BizException(OutsideUserMsg.USER_ORG_NAME_IS_EMPTY.getCode(),OutsideUserMsg.USER_ORG_NAME_IS_EMPTY.getName());
            }
            if(StringUtils.trimToEmpty(status).isEmpty()){
                throw new BizException(OutsideUserMsg.USER_STATUS_EXISTS.getCode(),OutsideUserMsg.USER_STATUS_EXISTS.getName());
            }
            if(Integer.valueOf(0).equals(rsaState)){ // 开启RSA加密字段
                // 对加密字段进行RSA解密
                try {
                    logger.info("准备解密name = {}",name);
                    user.setName(SaltUtil.decryptNosalt(name, privateKey));
                    logger.info("准备解密fullName = {}",fullName);
                    user.setFullName(SaltUtil.decryptNosalt(fullName, privateKey));
                    logger.info("准备解密orgNames = {}",orgNames);
                    /*String decryOrg = SaltUtil.decryptNosalt(orgNames, privateKey);
                    user.setOrgNames(orgRoot+decryOrg);*/
                    user.setOrgNames(orgRoot+orgNames);
                    String email = user.getEmail();
                    if(!StringUtils.trimToEmpty(email).isEmpty()){
                        logger.info("准备解密email = {}",email);
                        user.setEmail(SaltUtil.decryptNosalt(email, privateKey));
                    }
                    String mobile = user.getMobile();
                    if(!StringUtils.trimToEmpty(mobile).isEmpty()){
                        logger.info("准备解密mobile = {}",mobile);
                        user.setMobile(SaltUtil.decryptNosalt(mobile, privateKey));
                    }
                    String workNum = user.getWorkNum();
                    if(!StringUtils.trimToEmpty(workNum).isEmpty()){
                        logger.info("准备解密workNum = {}",workNum);
                        user.setWorkNum(SaltUtil.decryptNosalt(workNum, privateKey));
                    }
                    String sex = user.getSex();
                    if(!StringUtils.trimToEmpty(sex).isEmpty()){
                        logger.info("准备解密sex = {}",sex);
                        user.setSex(SaltUtil.decryptNosalt(sex, privateKey));
                    }
                    String position = user.getPosition();
                    if(!StringUtils.trimToEmpty(position).isEmpty()){
                        logger.info("准备解密position = {}",position);
                        user.setPosition(SaltUtil.decryptNosalt(position, privateKey));
                    }
                    String idNumber = user.getIdNumber();
                    if(!StringUtils.trimToEmpty(idNumber).isEmpty()){
                        logger.info("准备解密idNumber = {}",idNumber);
                        user.setIdNumber(SaltUtil.decryptNosalt(idNumber, privateKey));
                    }
                }catch (Exception e){
                    logger.info("解密发生异常 = {}", e);
                    throw new BizException(OutsideUserMsg.USER_INFO_DECRYP_ERROR.getCode(),OutsideUserMsg.USER_INFO_DECRYP_ERROR.getName());
                }
            }
        }
    }

    /**
     * 同步组织
     * @param siteCode
     * @param companyId
     * @param companyCode
     * @param orgSelectd
     * @param orgGroups
     * @return
     */
    private boolean syncOrg(String siteCode, Long companyId, String companyCode, Map<String, Long> orgSelectd, Set<String> orgGroups) {
        boolean isNewOrg = false;
        Map<Long, Integer> layerSort = new HashMap<>(); // 每层使用的sort数值
        logger.info("分组的组织信息={}", JSON.toJSONString(orgGroups));
        for(String org : orgGroups){
            logger.info("未分割的组织信息={}", org);
            String[]  orgNameArrays = org.split(SPLIT);
            int arraySize = orgNameArrays.length;
            String mapKey = "";
            // 父组织id
            long parentId = 0;
            long rootId = 0;

            List<Long> orgIdArrays = new ArrayList<>();

            for(int i=0; i<arraySize; i++){
                String orgName = orgNameArrays[i];
                logger.info("组织名={}",orgName);
                if(i==0){
                    mapKey = orgName;
                }else {
                    mapKey+=SPLIT+ orgName;
                }
                logger.info("组织key={}",mapKey);
                if(orgSelectd.containsKey(mapKey)){
                    parentId = orgSelectd.get(mapKey);
                    if(i == 0){
                        rootId = parentId;
                    }
                    orgIdArrays.add(parentId);
                    continue;
                }else {
                    EntityWrapper<Organization> dbOrgEw = QueryUtil.condition(new Organization());
                    String [] orgInfo = null;
                    if(orgName.indexOf(ORG_INFO_SPLIT)>=0){
                        //orgInfo = orgName.split("\\+");ORG_INFO_SPLIT
                        orgInfo = orgName.split(ORG_INFO_SPLIT);
                        dbOrgEw.eq("company_id",companyId).eq("en_name", orgInfo[1]);
                    }else{
                        dbOrgEw.eq("company_id",companyId).eq("name", orgName);
                    }

                    if(parentId>0){
                        logger.info("条件={}",parentId);
                        dbOrgEw.eq("parent_id", parentId);
                    }
                    Organization dbOrg = organizationService.selectOne(dbOrgEw);
                    logger.info("dbOrg={}",dbOrg);
                    if(dbOrg == null){ // 新增组织
                        isNewOrg = true;
                        long id = idGenerator.generate();
                        dbOrg = new Organization();
                        dbOrg.setId(id);
                        String uuid = UUID.randomUUID().toString().replace("_","");
                        dbOrg.setCode(companyCode+"_"+siteCode+"_"+uuid);

                        dbOrg.setRootId(rootId);
                        dbOrg.setParentId(parentId);

                        // 设置排序字段
                        if(parentId == 0){
                            dbOrg.setSort(1);
                        }else {
                            if(layerSort.containsKey(parentId)){
                                int sortTmp = layerSort.get(parentId)+1;
                                dbOrg.setSort(sortTmp);
                                layerSort.put(parentId, sortTmp);
                            }else{
                                int dbMaxSort = organizationService.getMaxSort(companyId, parentId)+1;
                                dbOrg.setSort(dbMaxSort);
                                layerSort.put(parentId, dbMaxSort);
                            }
                        }

                        if(orgInfo != null){
                            dbOrg.setEnName(orgInfo[1]);
                            dbOrg.setName(orgInfo[0]);
                            if(orgInfo.length == 3){
                                String sort = orgInfo[2];
                                if(Objects.nonNull(sort) && Integer.valueOf(orgInfo[2]) > 0 ){
                                    dbOrg.setSort(Integer.valueOf(orgInfo[2]));
                                }
                            }
                        }else {
                            dbOrg.setName(orgName);
                        }
                        //dbOrg.setParentIdLayer(orgIdArrays.stream().map(orgIdItem -> orgIdItem.toString()).collect(Collectors.joining("_"))+"_"+id);
                        String currOrgId = "_"+id;
                        String parentIds = orgIdArrays.stream().map(orgIdItem -> orgIdItem.toString()).collect(Collectors.joining("_"));
                        if(parentIds.indexOf(currOrgId) >=0 ){
                            parentIds = parentIds.replace(currOrgId, "");
                        }
                        dbOrg.setParentIdLayer(parentIds);
                        dbOrg.setCompanyId(companyId);
                        int layer = i+1;
                        dbOrg.setLayer(layer);

                        dbOrg.setDeleted(false);
                        dbOrg.setDescription("AUTO_CREATE");
                        dbOrg.setCreateTime(new Date());
                        dbOrg.setCreateById(ACCOUNT_ID);
                        dbOrg.setCreateByName("system");
                        organizationService.insert(dbOrg);
                    } else {
                        if(orgInfo != null){
                            String dbOrgName = dbOrg.getName();
                            if(!orgInfo[0].equals(dbOrgName) || (orgInfo.length == 3 && !orgInfo[2].equals(dbOrg.getSort()))){
                                isNewOrg = true;
                                Organization dbOrgUp = new Organization();
                                dbOrgUp.setId(dbOrg.getId());
                                dbOrgUp.setName(orgInfo[0]);
                                if(orgInfo.length == 3) {
                                    dbOrgUp.setSort(Integer.valueOf(orgInfo[2]));
                                }
                                dbOrgUp.setUpdateById(ACCOUNT_ID);
                                dbOrgUp.setUpdateByName("system");
                                dbOrgUp.setUpdateTime(new Date());
                                organizationService.updateById(dbOrgUp);
                            }
                        }
                    }
                    // 设置每层的id
                    orgIdArrays.add(dbOrg.getId());

                    if(i == 0){
                        rootId = dbOrg.getId();
                    }
                    parentId = dbOrg.getId();
                    orgSelectd.put(mapKey, dbOrg.getId());
                }
                logger.info("每层级的组织信息={}",JSON.toJSONString(orgIdArrays));
            }
        }
        return isNewOrg;
    }

    /**
     * 批量新增用户
     * @param companyId
     * @param users
     * @param orgSelectd
     */
    private void addUsers(Long companyId, Long siteId, List<OutsideUserVO> users, Map<String, Long> orgSelectd, boolean orgIdByMap) {
        // 循环生成新用户信息
        List<Account> addAccounts = new ArrayList<>();
        for(OutsideUserVO newUser : users){
            Account user = new Account();
            Long userId = idGenerator.generate();
            user.setId(userId);
            user.setName(newUser.getName());
            String idNumber = newUser.getIdNumber();
            user.setIdNumber(idNumber);
            if(idNumber != null){
                int strLength = idNumber.length();
                int indexStart = strLength - 6;
                String pwd = idNumber.substring(indexStart);
                user.setPassword(ShaEncrypt.encryptNewPassword(pwd));
            }else{
                user.setPassword(ShaEncrypt.encryptNewPassword("123456")); // 密码（必须要指定）
            }

            // 备注字段2 存放站点信息
            user.setRemarkSecond(siteId.toString());
            // 用户在离职状态
            String status = newUser.getStatus();
            if(!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(status))){
                // 备注字段1 存放对接用户的状态信息
                user.setRemarkFirst(newUser.getStatus());
                if("2".equals(status)){
                    user.setEnabled(false);
                }else {
                    user.setEnabled(true);
                }
            }
            //user.setHeadPortrait(""); // 用户头像
            //user.setEnabled(true);
            user.setLocked(false);
            if(orgIdByMap){
                user.setOrgId(orgSelectd.get(newUser.getOrgNames()));
            }else{
                user.setOrgId(newUser.getOrgId());
            }
            user.setCompanyId(companyId);
            //user.setTelephone(null);
            user.setMobile(newUser.getMobile());
            user.setEmail(newUser.getEmail());
            user.setExpiredType(1);
            user.setEnabledTime(new Date());
            user.setSex(newUser.getSex());
            user.setPosition(newUser.getPosition());
            user.setFullName(newUser.getFullName());
            user.setWorkNum(newUser.getWorkNum());
            user.setCreateById(ACCOUNT_ID);
            user.setCreateByName("system");
            user.setCreateTime(new Date());
            addAccounts.add(user);
        }
        // 批量新增用户

        accountService.insertBatch(addAccounts);
    }


    /**
     * 更新用户
     * @param syncUserNames
     * @param dbUserNames
     * @param updateUsers
     */
    private String updateUsers(Map<String, OutsideUserVO> syncUserNames, Map<String, OutsideUserVO> dbUserNames, Set<String> updateUsers, Long siteId, Path saveErrorData) {
        StringBuilder errorText = new StringBuilder(System.getProperty("line.separator")+"重复数据"+System.getProperty("line.separator"));

        String error = "";
        List<Account> updateAccounts = new ArrayList<>();
        for(String itemName : updateUsers){
            OutsideUserVO syncItem = syncUserNames.get(itemName);
            OutsideUserVO dbItem = dbUserNames.get(itemName);

            Long dbSiteId = dbItem.getSiteId();
            if(!siteId.equals(dbSiteId)){
                errorText.append("同步的数据=").append(JSON.toJSONString(syncItem)).append(File.separator);
                errorText.append("平台数据库存在的数据=").append(JSON.toJSONString(dbItem)).append(File.separator);
                errorText.append(System.getProperty("line.separator"));
                error = "同步用户存和其他站点用户信息重复";
                continue;
            }

            boolean updateFlg = false;

            logger.info("请求的用户信息={}", JSON.toJSONString(syncItem));
            logger.info("数据库存在的用户信息={}", JSON.toJSONString(dbItem));

            Account upItem = new Account();
            upItem.setId(dbItem.getId());

            // 用户名字
            String fullName = syncItem.getFullName();
            if(!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(fullName)) && !fullName.equals(dbItem.getFullName())){
                updateFlg = true;
                upItem.setFullName(dbItem.getFullName());
            }

            // 用户在离职状态
            String status = syncItem.getStatus();
            if(!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(status))){
                updateFlg = true;
                upItem.setRemarkFirst(status);
                if("2".equals(status)){
                    upItem.setEnabled(false);
                }else {
                    upItem.setEnabled(true);
                }
            }

            // 用户组织id
            Long orgId = syncItem.getOrgId();
            if(!orgId.equals(dbItem.getOrgId())){
                updateFlg = true;
                upItem.setOrgId(orgId);
            }

            // 邮箱
            String email = syncItem.getEmail();
            if(!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(email)) && !email.equals(dbItem.getEmail())){
                updateFlg = true;
                upItem.setEmail(email);
            }

            // 手机号码
            String mobile = syncItem.getMobile();
            if(!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(mobile)) && !mobile.equals(dbItem.getMobile())){
                updateFlg = true;
                upItem.setMobile(mobile);
            }

            // 工号
            String workNum = syncItem.getWorkNum();
            if(!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(workNum)) && !workNum.equals(dbItem.getWorkNum())){
                updateFlg = true;
                upItem.setWorkNum(workNum);
            }

            // 性别（M：男，F:女）
            String sex = syncItem.getSex();
            if(!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(sex)) && !sex.equals(dbItem.getSex())){
                updateFlg = true;
                upItem.setSex(sex);
            }

            // 职位
            String position = syncItem.getPosition();
            if(!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(position)) && !position.equals(dbItem.getPosition())){
                updateFlg = true;
                upItem.setPosition(position);
            }

            // 身份证号
            String idNumber = syncItem.getIdNumber();
            if(!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(idNumber)) && !idNumber.equals(dbItem.getIdNumber())){
                updateFlg = true;
                upItem.setIdNumber(idNumber);
                int strLength = idNumber.length();
                int indexStart = strLength - 6;
                String pwd = idNumber.substring(indexStart);
                upItem.setPassword(ShaEncrypt.encryptNewPassword(pwd));
            }

            if(updateFlg){
                upItem.setUpdateById(ACCOUNT_ID);
                upItem.setUpdateByName("system");
                upItem.setUpdateTime(new Date());
                updateAccounts.add(upItem);
            }
        }
        if(!CollectionUtils.isEmpty(updateAccounts)){
            accountService.updateBatchById(updateAccounts);
        }
        try {
            Files.write(saveErrorData, errorText.toString().getBytes(StandardCharsets.UTF_8),StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return error;
    }

}
