package com.yizhi.system.application.task;

import com.alibaba.fastjson.JSON;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.system.application.domain.SensitiveWord;
import com.yizhi.system.application.service.ISensitiveWordService;
import com.yizhi.util.application.json.JsonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 14:24 2018/6/11
 * @Modified By
 */
@Component
public class SensitiveTask extends AbstractTaskHandler {

    @Autowired
    RedisCache redisCache;
    @Autowired
	ISensitiveWordService sensitiveWordService;

    private static final Logger logger = LoggerFactory.getLogger(SensitiveTask.class);

	@Override
	public void handle() {
		Long companyId=this.taskContext.getCompanyId();
	    logger.info("敏感词同步到redis处理开始，企业id="+companyId);
        try {
            redisCache.delete(CacheNamespace.REDIS_SENSITIVE_WORD_INFO);
            com.yizhi.system.application.domain.SensitiveWord sensitiveWord = new com.yizhi.system.application.domain.SensitiveWord();
            sensitiveWord.setCompanyId(companyId);
            sensitiveWord.setDeleted(false);
            List<SensitiveWord> listObj = sensitiveWordService.selectList(QueryUtil.condition(sensitiveWord));
            logger.info("查询出来的敏感词对象={}", JSON.toJSONString(listObj));
            if(CollectionUtils.isNotEmpty(listObj)){
                Set<String> objSet = new HashSet<>();
                listObj.forEach(item ->{objSet.add(item.getName());});
                redisCache.hset(CacheNamespace.REDIS_SENSITIVE_WORD_INFO,companyId+"", JsonUtil.object2Json(objSet));
            }
            logger.info("敏感词同步到redis处理完成，企业id="+companyId);
        } catch (Exception e) {
            logger.error("敏感词同步redis异常",e);
        }
		
	}
}
