package com.yizhi.system.application.task;

import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.system.application.domain.dto.SiteProtectExportDTO;
import com.yizhi.system.application.domain.dto.SiteProtectTaskDTO;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.system.application.service.SiteProtectService;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Component
@Slf4j
public class SiteProtectExport extends AbstractDefaultTask<String, SiteProtectTaskDTO> {


	@Autowired
	private SiteProtectService siteProtectService;

	@Override
	protected String execute(SiteProtectTaskDTO siteProtectTaskDTO) {
		Long taskId = siteProtectTaskDTO.getTaskId();
		String taskName = siteProtectTaskDTO.getTaskName();
		RequestContext res = siteProtectTaskDTO.getRequestContext();
		Long accountId = res.getAccountId();
		Date submitTime = new Date();
		SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMddHHmmss");
		List<Long> siteNoticeIdList = siteProtectTaskDTO.getSiteNoticeIdList();
		TaskContext taskContext = new TaskContext(taskId, taskName,  accountId, submitTime);
		taskContext.setSiteId(res.getSiteId());
		taskContext.setCompanyId(res.getCompanyId());
		working(taskContext);
		List<SiteProtectExportDTO> list = siteProtectService.list(siteNoticeIdList);
		String sheetName = "【"+taskName+"】" + "-"+df2.format(submitTime);
		String upLoadUrl = null;
		try {
			XSSFWorkbook wb = new XSSFWorkbook();
			XSSFSheet sheet = wb.createSheet(sheetName);
			XSSFRow row = sheet.createRow(0);
			XSSFCellStyle style = wb.createCellStyle();
			style.setAlignment(HorizontalAlignment.CENTER); // 创建一个居中格式
			CellRangeAddress cra = new CellRangeAddress(0, 0, 0, 6); // 起始行, 终止行, 起始列, 终止列
			sheet.addMergedRegion(cra);
			XSSFCell cell = row.createCell(0);
			cell.setCellValue(sheetName);
			cell.setCellStyle(style);
			XSSFRow row2 = sheet.createRow( 1);
			row2.createCell(0).setCellValue("维护名称");
			row2.createCell(1).setCellValue("维护方式");
			row2.createCell(2).setCellValue("站点编码");
			row2.createCell(3).setCellValue("站点名称");
			row2.createCell(4).setCellValue("企业名称");
			row2.createCell(5).setCellValue("开始时间");
			row2.createCell(6).setCellValue("结束时间");
			// 第五步，写入实体数据 实际应用中这些数据从数据库得到，
			if (CollectionUtils.isNotEmpty(list)) {
				SiteProtectExportDTO rscv = null;
				for (int i = 0; i < list.size(); i++) {
					row = sheet.createRow(i + 2);
					rscv = list.get(i);
					// 第四步，创建单元格，并设置值
					row.createCell(0).setCellValue(rscv.getName());
					row.createCell(1).setCellValue(rscv.getNoticeType());
					row.createCell(2).setCellValue(rscv.getSiteCode());
					row.createCell(3).setCellValue(rscv.getSiteName());
					row.createCell(4).setCellValue(rscv.getCompanyName());
					row.createCell(5).setCellValue(rscv.getStartTime());
					row.createCell(6).setCellValue(rscv.getEndTime());
				}
			}
			String fileName = sheetName + ".xlsx";
			String requestPath = FileConstant.SAVE_PATH;
			File fileDir = new File(requestPath);
			if (!fileDir.exists()) {
				fileDir.mkdir();
			}
			String path = requestPath + File.separator + fileName;
			FileOutputStream os = null;
			File file = null;
			try {
				os = new FileOutputStream(path);
				wb.write(os);
				// 阿里云返回url
				upLoadUrl = OssUpload.upload(path, fileName);
				file = new File(path);
				success(taskContext, "成功", upLoadUrl);
			} catch (Exception e1) {
				fail(taskContext, "写入过程中发生错误");
				log.error("上传过程中发生错误，请查看日志,异常信息-----{}",e1);
			} finally {
				if (os != null) {
					os.close();
				}
				if (wb != null) {
					wb.close();
				}
				if (file != null) {
					file.delete();
				}
			}

		} catch (Exception e) {
			fail(taskContext, sheetName + "导出过程中发生错误，请查看日志" + e.getMessage());
			log.error(sheetName + "导出过程中发生错误，请查看日志,异常信息------{}",e);
		}
		return upLoadUrl;
	}
}
