package com.yizhi.system.application.util;


import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LanguageUtil {

    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private RedisCache redisCache;

    /**
     * 设置用户选择的语言缓存
     * @param languageCode
     */
    public void setStudentSelectLanguageRecordCache(RequestContext context, String languageCode){
        if (languageCode != null && StringUtils.isNotBlank(languageCode)) {
            redisCache.hset(CacheNamespace.SITE_LANGUAGE_STUDENT_SELECT, context.getAccountId().toString(), languageCode);
        }
    }

    /**
     * 设置用户选择的语言 入库
     * @param languageCode
     */
    public void setStudentSelectLanguageRecord(RequestContext context,String languageCode){

        //后续需要入库

    }

    /**
     * 登录成功后设置用户选择的语言
     * @param context
     * @param languageCode
     */
    public void setStudentSelectLanguage(RequestContext context,String languageCode){
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                setStudentSelectLanguageRecordCache(context,languageCode);
                setStudentSelectLanguageRecord(context,languageCode);
            }
        });
    }
}
