package com.yizhi.system.application.util;

import javax.xml.bind.DatatypeConverter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Util {

    /**
     * MD5 (32位大写）
     * @param str
     * @return
     * @throws NoSuchAlgorithmException
     */
    public static String generateUpperCase(String str) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(str.getBytes());
        byte[] digest = md.digest();
        String myHash = DatatypeConverter.printHexBinary(digest);
        //String myHash = DatatypeConverter.printHexBinary(digest).toUpperCase();
        return myHash;
    }

    /**
     * MD5 (32位小写）
     * @param str
     * @return
     * @throws NoSuchAlgorithmException
     */
    public static String generateLowerCase(String str) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(str.getBytes());
        byte[] b = md.digest();
        int i;
        StringBuffer buf = new StringBuffer();
        for (int offset = 0; offset < b.length; offset++) {
            i = b[offset];
            if (i < 0)
                i += 256;
            if (i < 16)
                buf.append("0");
            buf.append(Integer.toHexString(i));
        }
        String myHash = buf.toString();
        return myHash;
    }

    public static void main(String[] args) {
        String password = "123456";
        try {
            String result = generateUpperCase("123456");
            System.out.println("MD5(" + password + ",32小写) = " + result);
            System.out.println("MD5(" + password + ",32大写) = " + result.toUpperCase());

            System.out.println("MD5(" + password + ",16小写) = " + result.substring(8, 24));
            System.out.println("MD5(" + password + ",16大写) = " + result.substring(8, 24).toUpperCase());
            System.out.println(result);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}
