package com.yizhi.system.application.util;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

import javax.crypto.Cipher;

import com.alibaba.fastjson.JSON;
import org.apache.commons.codec.binary.Base64;
 
public class RSAUtil {
    //用于封装随机产生的公钥与私钥
    private static Map<Integer, String> keyMap = new HashMap<Integer, String>();

    /**
     * 公钥
     */
    public static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCPIjC59XW5ttO2KgOJwXUwVKDeorpf2wANnWrk4QvPKW7v5Ly7+NlindsRgu0s+gCMb74uLW2CeshL1t6iWPr4+bmv9qodVz3R+ABouJ33nyaNc3Fk3YFAnhVOMwSpKdJBLwl4S6OjMqR0/GbeXiH/+mUdl/bF5HDrotdURRXL0wIDAQAB";

    /**
     * 私钥
     */
    public static final String PRIVATE_KEY = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAI8iMLn1dbm207YqA4nBdTBUoN6iul/bAA2dauThC88pbu/kvLv42WKd2xGC7Sz6AIxvvi4tbYJ6yEvW3qJY+vj5ua/2qh1XPdH4AGi4nfefJo1zcWTdgUCeFU4zBKkp0kEvCXhLo6MypHT8Zt5eIf/6ZR2X9sXkcOui11RFFcvTAgMBAAECgYBrjuXO2AV/aUPuv+OowRevGelJZD9piMihconBNNwK8LfMzbaGCppQ4Q6eOiTAh52h6tafHMQOKPYbB3yFwxfUn/5+RhhsDU0dc4FWIKyMrQQwJZTerVWVrcmCLGqVRHEPNUkdfZ8s4tF/9ZBriFx+bRrjoc7+OW1oqgCX9ktKAQJBANFBOlSmrUDgBBfEuP8DKz00U2NCK4JBDJhwEbveux1G4LWelc/yvbcdsruyx3IakNN8yxsJt0V1lIeANgGaTAsCQQCvG6ZY3xS8aTnUGLRfRGXIfc1kKTau+1Jx8Cxh9NmtXTKygz1FUIenyB3ezzKSftUR0R0cBK1vA9AU+KA5UZRZAkEAoiV4LKYnNFEh+sT+UOTEuZ11TEG28yyytOCKbViPB4WnlDR5g/Rl26IQoG9NKva46JgXzjC+Kf2NhV3s+1rztwJBAIvL1j0DNAnLNCi45F9eOqgajzwUjxyZdlOSO8ykbpgyXIQZtHO++94eLIKyBhzgdvh3avbwYQnNEHV9nGTGVVkCQEtUSX4+o++Zw7eVVnlFOvrSrM09uFqD5gBqhaMxzxMqHggSidlXigAQCz+2Dzsn/sy3GpySWYi7Iv2ysDYtMSw=";


    public static final String MODEL = "RSA";

    public static final Integer PUBLIC_INDEX = 0;
    public static final Integer PRIVATE_INDEX = 1;

    /**
     * APPID
     */
    public static final String UUIDSTRING = "8ea8ef8e-ba70-4055-bcc7-86e72b0756aa";
 

    /**
     * 随机生成密钥对
     *
     * @throws NoSuchAlgorithmException
     */
    public static void genKeyPair() throws NoSuchAlgorithmException {
        // KeyPairGenerator类用于生成公钥和私钥对，基于RSA算法生成对象
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(MODEL);
        // 初始化密钥对生成器，密钥大小为96-1024位
        keyPairGen.initialize(1024, new SecureRandom());
        // 生成一个密钥对，保存在keyPair中
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey) keyPair.getPrivate();
        // 得到私钥
        RSAPublicKey publicKey = (RSAPublicKey) keyPair.getPublic();
        // 得到公钥
        String publicKeyString = new String(Base64.encodeBase64(publicKey.getEncoded()));
        // 得到私钥字符串
        String privateKeyString = new String(Base64.encodeBase64((privateKey.getEncoded())));
        // 将公钥和私钥保存到

//        keysMap.put(publicKeyString, privateKeyString);

        keyMap.put(PUBLIC_INDEX, publicKeyString);
//        // 0表示公钥
        keyMap.put(PRIVATE_INDEX, privateKeyString);
//        // 1表示私钥
        System.out.println(JSON.toJSONString(keyMap));
    }

    /**
     * RSA公钥加密
     *
     * @param str       加密字符串
     * @param publicKey 公钥
     * @return 密文
     * @throws Exception 加密过程中的异常信息
     */
    public static String encrypt(String str, String publicKey) throws Exception {
        //base64编码的公钥
        byte[] decoded = Base64.decodeBase64(publicKey);
        RSAPublicKey pubKey = (RSAPublicKey) KeyFactory.getInstance(MODEL).generatePublic(new X509EncodedKeySpec(decoded));
        //RSA加密
        Cipher cipher = Cipher.getInstance(MODEL);
        cipher.init(Cipher.ENCRYPT_MODE, pubKey);
        String outStr = Base64.encodeBase64String(cipher.doFinal(str.getBytes(StandardCharsets.UTF_8)));
        return outStr;
    }

    /**
     * RSA私钥解密
     *
     * @param str        加密字符串
     * @param privateKey 私钥
     * @return 铭文
     * @throws Exception 解密过程中的异常信息
     */
    public static String decrypt(String str, String privateKey) throws Exception {
        //64位解码加密后的字符串
        byte[] inputByte = Base64.decodeBase64(str.getBytes(StandardCharsets.UTF_8));
        // base64编码的私钥
        byte[] decoded = Base64.decodeBase64(privateKey);
        RSAPrivateKey priKey = (RSAPrivateKey) KeyFactory.getInstance(MODEL).generatePrivate(new PKCS8EncodedKeySpec(decoded));
        // RSA解密
        Cipher cipher = Cipher.getInstance(MODEL);
        cipher.init(Cipher.DECRYPT_MODE, priKey);
        String outStr = new String(cipher.doFinal(inputByte));
        return outStr;
    }


}